/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import org.eclipse.mat.inspections.collections.AbstractFillRatioQuery;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="array_fill_ratio")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
public class ArrayFillRatioQuery
extends AbstractFillRatioQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public int segments = 5;

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask(Messages.ArrayFillRatioQuery_ExtractingFillRatios);
        Quantize.Builder builder = Quantize.linearFrequencyDistribution((String)Messages.ArrayFillRatioQuery_ColumnFillRatio, (double)0.0, (double)1.0, (double)(1.0 / (double)this.segments));
        builder.column(Messages.ArrayFillRatioQuery_ColumnNumObjects, Quantize.COUNT);
        builder.column(Messages.Column_ShallowHeap, Quantize.SUM_LONG);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        this.runQuantizer(listener, quantize, null, null, this.snapshot, this.objects);
        return quantize.getResult();
    }
}

