/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.collectionextract.FieldArrayCollectionExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;

public class IBM6ArrayListCollectionExtractor
extends FieldArrayCollectionExtractor {
    private String firstIndex;
    private String lastIndex;

    public IBM6ArrayListCollectionExtractor(String firstIndex, String lastIndex, String arrayField) {
        super(arrayField);
        if (firstIndex == null) {
            throw new IllegalArgumentException();
        }
        if (lastIndex == null) {
            throw new IllegalArgumentException();
        }
        this.firstIndex = firstIndex;
        this.lastIndex = lastIndex;
    }

    public boolean hasSize() {
        return true;
    }

    public Integer getSize(IObject coll) throws SnapshotException {
        Integer firstIndex = (Integer)coll.resolveValue(this.firstIndex);
        Integer lastIndex = (Integer)coll.resolveValue(this.lastIndex);
        if (lastIndex == null) {
            return null;
        }
        if (firstIndex == null || lastIndex <= 0) {
            return lastIndex;
        }
        if (lastIndex >= firstIndex) {
            return lastIndex - firstIndex;
        }
        return lastIndex - firstIndex + this.getCapacity(coll);
    }

    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        ISnapshot snapshot = coll.getSnapshot();
        long[] referenceArray = this.extractEntries(coll).getReferenceArray();
        Integer size = this.getSize(coll);
        if (size == null) {
            return new int[0];
        }
        ArrayInt arr = new ArrayInt(size.intValue());
        if (size > 0) {
            int firstIndex = (Integer)coll.resolveValue(this.firstIndex);
            int lastIndex = (Integer)coll.resolveValue(this.lastIndex);
            int end = this.getCapacity(coll);
            int i = firstIndex;
            while (i < (firstIndex <= lastIndex ? lastIndex : end)) {
                if (referenceArray[i] != 0L) {
                    arr.add(snapshot.mapAddressToId(referenceArray[i]));
                }
                ++i;
            }
            i = 0;
            while (i < (firstIndex <= lastIndex ? 0 : lastIndex)) {
                if (referenceArray[i] != 0L) {
                    arr.add(snapshot.mapAddressToId(referenceArray[i]));
                }
                ++i;
            }
        }
        return arr.toArray();
    }
}

