/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.AbstractExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.inspections.collectionextract.ExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.ExtractedMap;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class WrapperCollectionExtractor
implements ICollectionExtractor {
    private final String field;
    private final ICollectionExtractor extractor;

    public WrapperCollectionExtractor(String field) {
        this(field, null);
    }

    public WrapperCollectionExtractor(String field, ICollectionExtractor extractor) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        this.field = field;
        this.extractor = extractor;
    }

    public boolean hasSize() {
        return true;
    }

    public Integer getSize(IObject coll) throws SnapshotException {
        AbstractExtractedCollection extractCollection = this.extractCollection(coll);
        return extractCollection != null ? extractCollection.size() : null;
    }

    public boolean hasCapacity() {
        return true;
    }

    public Integer getCapacity(IObject coll) throws SnapshotException {
        AbstractExtractedCollection extractCollection = this.extractCollection(coll);
        return extractCollection != null ? this.extractCollection(coll).getCapacity() : null;
    }

    public boolean hasFillRatio() {
        return true;
    }

    public Double getFillRatio(IObject coll) throws SnapshotException {
        AbstractExtractedCollection extractCollection = this.extractCollection(coll);
        return extractCollection != null ? extractCollection.getFillRatio() : null;
    }

    public boolean hasExtractableContents() {
        return true;
    }

    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        return this.extractCollection(coll).extractEntryIds();
    }

    public boolean hasExtractableArray() {
        return true;
    }

    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        return this.extractCollection(coll).extractEntries();
    }

    public Integer getNumberOfNotNullElements(IObject coll) throws SnapshotException {
        return this.extractList(coll).getNumberOfNotNullElements();
    }

    protected ExtractedCollection extractList(IObject coll) {
        AbstractExtractedCollection ec = this.extractCollection(coll);
        if (ec instanceof ExtractedCollection) {
            return (ExtractedCollection)ec;
        }
        throw new UnsupportedOperationException("not a list-ish collection: " + coll.getDisplayName() + "; " + ec.getDisplayName());
    }

    protected ExtractedMap extractMap(IObject coll) {
        AbstractExtractedCollection ec = this.extractCollection(coll);
        if (ec instanceof ExtractedMap) {
            return (ExtractedMap)ec;
        }
        throw new UnsupportedOperationException("not a map: " + coll.getDisplayName() + ec != null ? "; " + ec.getDisplayName() : "");
    }

    protected AbstractExtractedCollection extractCollection(IObject coll) {
        try {
            IObject value = (IObject)coll.resolveValue(this.field);
            if (value == null) {
                return this.guessWrappedFromOutbounds(coll);
            }
            if (this.extractor == null) {
                return CollectionExtractionUtils.extractCollection(value);
            }
            if (this.extractor instanceof IMapExtractor) {
                return new ExtractedMap(value, (IMapExtractor)this.extractor);
            }
            return new ExtractedCollection(value, this.extractor);
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    private AbstractExtractedCollection guessWrappedFromOutbounds(IObject coll) throws SnapshotException {
        int[] outbounds;
        ISnapshot snapshot = coll.getSnapshot();
        AbstractExtractedCollection<?, ?> extracted = null;
        int[] nArray = outbounds = snapshot.getOutboundReferentIds(coll.getObjectId());
        int n = outbounds.length;
        int n2 = 0;
        while (n2 < n) {
            int outId = nArray[n2];
            AbstractExtractedCollection<?, ?> ex = CollectionExtractionUtils.extractCollection(snapshot.getObject(outId));
            if (ex != null) {
                if (extracted == null) {
                    extracted = ex;
                } else {
                    throw new IllegalArgumentException("Could not resolve field " + this.field + " of " + coll.getTechnicalName() + " (found multiple outbound references to collections)");
                }
            }
            ++n2;
        }
        if (extracted != null) {
            return extracted;
        }
        throw new IllegalArgumentException("Could not resolve field " + this.field + " of " + coll.getTechnicalName() + " (found no outbound references to collections)");
    }
}

