/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.ibmvm.acquire.IBMDumpProvider;
import org.eclipse.mat.ibmvm.acquire.Messages;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IBMSystemDumpProvider
extends IBMDumpProvider {
    IBMSystemDumpProvider() {
    }

    @Override
    String dumpName() {
        return "core.YYmmdd.HHMMSS.%pid%.seq.dmp";
    }

    @Override
    int files() {
        return 1;
    }

    @Override
    long averageFileSize(Collection<File> files) {
        long l = 0L;
        int i = 0;
        for (File f : files) {
            if (!f.isFile() || !f.getName().endsWith(".dmp")) continue;
            l += f.length();
            ++i;
        }
        if (i > 0) {
            return l / (long)i;
        }
        return 100000000L;
    }

    @Override
    File jextract(File preferredDump, boolean compress, List<File> dumps, File udir, File home, IProgressListener listener) throws IOException, InterruptedException, SnapshotException {
        File result;
        File dump = dumps.get(0);
        String encoding = System.getProperty("file.encoding", "UTF-8");
        String encodingOpt = "-J-Dfile.encoding=" + encoding;
        preferredDump = this.mergeFileNames(preferredDump, dump);
        if (compress && !preferredDump.getName().endsWith(".zip")) {
            preferredDump = new File(String.valueOf(preferredDump.getPath()) + ".zip");
        }
        int work = 1000;
        listener.beginTask(MessageFormat.format(Messages.getString("IBMSystemDumpProvider.FormattingDump"), dump, preferredDump), work);
        boolean zip = preferredDump.getName().endsWith(".zip");
        if (zip) {
            Process p;
            int exitCode;
            StringBuilder errorBuf;
            File jextract;
            block19: {
                long dumpLen = dump.length();
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                if (home != null) {
                    File homebin = new File(home, "bin");
                    jextract = new File(homebin, "jextract");
                } else {
                    jextract = new File("jextract");
                }
                pb.command(jextract.getAbsolutePath(), encodingOpt, dump.getAbsolutePath(), preferredDump.getAbsolutePath());
                result = preferredDump;
                pb.redirectErrorStream(true);
                pb.directory(udir);
                errorBuf = new StringBuilder();
                exitCode = 0;
                p = pb.start();
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream(), encoding));
                long outlen = 0L;
                long estimatedZipLen = 0x4000000L + dumpLen / 5L;
                long maxEstimatedZipLen = estimatedZipLen * 2L;
                int f1 = 3;
                int f2 = 4;
                while (true) {
                    while (br.ready()) {
                        int t = br.read();
                        if (t < 0) break;
                        errorBuf.append((char)t);
                    }
                    listener.subTask("\n" + errorBuf.toString());
                    long newlen = result.length();
                    long step = newlen < (long)f1 * estimatedZipLen / (long)f2 ? estimatedZipLen / (long)work : (maxEstimatedZipLen - (long)f1 * estimatedZipLen / (long)f2) * (long)f2 / (long)(f2 - f1) / (long)work;
                    if (newlen - outlen > step) {
                        listener.worked((int)((newlen - outlen) / step));
                        outlen += (newlen - outlen) / step * step;
                    }
                    if (listener.isCanceled()) {
                        p.destroy();
                        return null;
                    }
                    try {
                        p.exitValue();
                        break block19;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        Thread.sleep(500L);
                        continue;
                    }
                    break;
                }
                finally {
                    br.close();
                }
            }
            exitCode = p.waitFor();
            if (exitCode != 0) {
                throw new SnapshotException(MessageFormat.format(Messages.getString("IBMSystemDumpProvider.ReturnCode"), jextract.getAbsolutePath(), exitCode, errorBuf.toString()));
            }
            if (!result.canRead()) {
                throw new FileNotFoundException(MessageFormat.format(Messages.getString("IBMSystemDumpProvider.ReturnCode"), result.getPath(), errorBuf.toString()));
            }
        } else {
            if (dump.renameTo(preferredDump)) {
                dump = preferredDump;
            }
            result = dump;
        }
        if (zip) {
            dump.delete();
        }
        listener.done();
        return result;
    }
}

