/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.acquire;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.acquire.HeapDumpProviderDescriptor;
import org.eclipse.mat.internal.acquire.HeapDumpProviderRegistry;
import org.eclipse.mat.query.annotations.descriptors.IAnnotatedObjectDescriptor;
import org.eclipse.mat.query.registry.AnnotatedObjectArgumentsSet;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentFactory;
import org.eclipse.mat.snapshot.acquire.VmInfo;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.editor.PathEditorInput;
import org.eclipse.mat.ui.internal.acquire.AcquireDialog;
import org.eclipse.mat.ui.internal.acquire.ProviderArgumentsWizardPage;
import org.eclipse.mat.ui.internal.acquire.ProviderConfigurationWizardPage;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class AcquireSnapshotAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public void run() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Collection dumpProviders = HeapDumpProviderRegistry.instance().getHeapDumpProviders();
        if (dumpProviders == null || dumpProviders.size() == 0) {
            this.showError(Messages.AcquireSnapshotAction_NoProviderError);
            return;
        }
        AcquireWizard wizard = new AcquireWizard(dumpProviders);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setHelpAvailable(true);
        dialog.open();
    }

    private void showError(String msg) {
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", null, (IStatus)ErrorHelper.createErrorStatus(msg));
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    static class AcquireDumpOperation
    implements IRunnableWithProgress {
        private IStatus status;
        private IRunnableContext context;
        private VmInfo vmInfo;
        private File preferredLocation;
        private File result;
        private AnnotatedObjectArgumentsSet argumentSet;

        public AcquireDumpOperation(VmInfo vmInfo, File preferredLocation, AnnotatedObjectArgumentsSet argumentSet, IRunnableContext context) {
            this.vmInfo = vmInfo;
            this.preferredLocation = preferredLocation;
            this.context = context;
            this.argumentSet = argumentSet;
        }

        private IStatus doOperation(IProgressMonitor monitor) {
            ProgressMonitorWrapper listener = new ProgressMonitorWrapper(monitor);
            try {
                this.result = this.triggerHeapDump(listener);
                if (listener.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
            }
            catch (Exception e) {
                return ErrorHelper.createErrorStatus(e);
            }
            return Status.OK_STATUS;
        }

        private File triggerHeapDump(IProgressListener listener) throws SnapshotException, SnapshotException {
            VmInfo impl = this.vmInfo;
            AcquireDumpOperation.setupVmInfo(this.vmInfo, this.argumentSet);
            File result = impl.getHeapDumpProvider().acquireDump(this.vmInfo, this.preferredLocation, listener);
            return result;
        }

        static void setupVmInfo(VmInfo vmInfo, AnnotatedObjectArgumentsSet argumentSet) throws SnapshotException {
            try {
                IAnnotatedObjectDescriptor providerDescriptor = argumentSet.getDescriptor();
                VmInfo impl = vmInfo;
                for (ArgumentDescriptor parameter : providerDescriptor.getArguments()) {
                    Object value = argumentSet.getArgumentValue(parameter);
                    if (value == null && parameter.isMandatory() && (value = parameter.getDefaultValue()) == null) {
                        throw new SnapshotException(MessageUtil.format((String)Messages.AcquireSnapshotAction_MissingParameterErrorMessage, (Object[])new Object[]{parameter.getName()}));
                    }
                    if (value == null) {
                        if (!argumentSet.getValues().containsKey(parameter)) continue;
                        Logger.getLogger(AcquireDumpOperation.class.getName()).log(Level.INFO, MessageUtil.format((String)"Setting null value for: {0}", (Object[])new Object[]{parameter.getName()}));
                        parameter.getField().set(impl, null);
                        continue;
                    }
                    try {
                        int ii;
                        if (value instanceof ArgumentFactory) {
                            parameter.getField().set(impl, ((ArgumentFactory)value).build(parameter));
                            continue;
                        }
                        if (parameter.isArray()) {
                            List list = (List)value;
                            Object array = Array.newInstance(parameter.getType(), list.size());
                            ii = 0;
                            for (Object v : list) {
                                Array.set(array, ii++, v);
                            }
                            parameter.getField().set(impl, array);
                            continue;
                        }
                        if (parameter.isList()) {
                            List source = (List)value;
                            ArrayList target = new ArrayList(source.size());
                            ii = 0;
                            while (ii < source.size()) {
                                Object v;
                                v = source.get(ii);
                                if (v instanceof ArgumentFactory) {
                                    v = ((ArgumentFactory)v).build(parameter);
                                }
                                target.add(v);
                                ++ii;
                            }
                            parameter.getField().set(impl, target);
                            continue;
                        }
                        parameter.getField().set(impl, value);
                    }
                    catch (IllegalArgumentException e) {
                        throw new SnapshotException(MessageUtil.format((String)Messages.AcquireSnapshotAction_IllegalTypeErrorMessage, (Object[])new Object[]{value, value.getClass().getName(), parameter.getName(), parameter.getType().getName()}), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new SnapshotException(MessageUtil.format((String)"Unable to access field {0} of type {1}", (Object[])new Object[]{parameter.getName(), parameter.getType().getName()}), (Throwable)e);
                    }
                }
            }
            catch (IProgressListener.OperationCanceledException e) {
                throw e;
            }
            catch (SnapshotException e) {
                throw e;
            }
            catch (Exception e) {
                throw SnapshotException.rethrow((Throwable)e);
            }
        }

        private File getResult() {
            return this.result;
        }

        public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.status = this.doOperation(monitor);
        }

        public final IStatus run() {
            try {
                this.context.run(true, true, (IRunnableWithProgress)this);
            }
            catch (Exception e) {
                this.status = ErrorHelper.createErrorStatus(Messages.AcquireSnapshotAction_UnexpectedException, e);
            }
            if (!this.status.isOK() && this.status != Status.CANCEL_STATUS) {
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", null, (IStatus)this.status);
            }
            return this.status;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcquireWizard
    extends Wizard
    implements IWorkbenchWizard {
        ProviderConfigurationWizardPage configPage;
        AcquireDialog acquireDialog;
        ProviderArgumentsWizardPage argumentsPage;
        Collection<HeapDumpProviderDescriptor> dumpProviders;

        public AcquireWizard(Collection<HeapDumpProviderDescriptor> dumpProviders) {
            this.dumpProviders = dumpProviders;
            this.setWindowTitle(Messages.AcquireSnapshotAction_AcquireDialogName);
            this.setNeedsProgressMonitor(true);
        }

        public AcquireWizard() {
            this(HeapDumpProviderRegistry.instance().getHeapDumpProviders());
        }

        public void addPages() {
            this.acquireDialog = new AcquireDialog(this.dumpProviders);
            this.configPage = new ProviderConfigurationWizardPage(this.acquireDialog);
            this.argumentsPage = new ProviderArgumentsWizardPage(this.acquireDialog);
            this.addPage((IWizardPage)this.configPage);
            this.addPage((IWizardPage)this.acquireDialog);
            this.addPage((IWizardPage)this.argumentsPage);
        }

        public boolean performFinish() {
            IContentType ct;
            Path path;
            block19: {
                AcquireDumpOperation dumpOperation;
                block17: {
                    File preferredLocation;
                    VmInfo selectedProcess;
                    block16: {
                        if (this.acquireDialog == null) {
                            return false;
                        }
                        selectedProcess = this.acquireDialog.getProcess();
                        try {
                            String selectedPath = this.acquireDialog.getSelectedPath();
                            preferredLocation = new File(selectedPath);
                            if (this.validatePath(preferredLocation)) break block16;
                            return false;
                        }
                        catch (Exception e) {
                            ErrorHelper.logThrowableAndShowMessage(e);
                            return false;
                        }
                    }
                    dumpOperation = new AcquireDumpOperation(selectedProcess, preferredLocation, this.argumentsPage.getArgumentSet(), (IRunnableContext)this.getContainer());
                    if (dumpOperation.run().isOK()) break block17;
                    AnnotatedObjectArgumentsSet args = this.argumentsPage.getArgumentSet();
                    this.argumentsPage.processSelected(null);
                    this.argumentsPage.processSelected(args);
                    return false;
                }
                File destFile = dumpOperation.getResult();
                path = new Path(destFile.getAbsolutePath());
                FileInputStream is = null;
                try {
                    try {
                        is = new FileInputStream(destFile);
                        ct = Platform.getContentTypeManager().findContentTypeFor((InputStream)is, destFile.getAbsolutePath());
                    }
                    catch (IOException iOException) {
                        ct = null;
                        if (is != null) {
                            is.close();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                if (is != null) {
                    is.close();
                }
            }
            IEditorDescriptor descriptor = ct != null ? PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(path.toOSString(), ct) : PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(path.toOSString());
            try {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)new PathEditorInput((IPath)path), (String)(descriptor != null ? descriptor.getId() : "org.eclipse.mat.ui.editors.HeapEditor"), (boolean)true);
                if (PlatformUI.getWorkbench().getIntroManager().getIntro() != null) {
                    PlatformUI.getWorkbench().getIntroManager().setIntroStandby(PlatformUI.getWorkbench().getIntroManager().getIntro(), true);
                }
            }
            catch (Exception e) {
                ErrorHelper.logThrowableAndShowMessage(e, String.valueOf(Messages.AcquireSnapshotAction_UnableToOpenEditor) + path);
            }
            if (new File(this.acquireDialog.getSelectedPath()).exists()) {
                this.acquireDialog.saveSettings();
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean validatePath(File destFile) {
            if (destFile.exists()) {
                if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.AcquireSnapshotAction_Confirmation, (String)Messages.AcquireSnapshotAction_FileAlreadyExists)) return false;
                destFile.delete();
                return true;
            } else {
                if (destFile.getParentFile() == null || destFile.getParentFile().exists()) return true;
                if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.AcquireSnapshotAction_Confirmation, (String)Messages.AcquireSnapshotAction_DirectoryDoesntExist)) return false;
                if (destFile.getParentFile().mkdirs()) return true;
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", null, (IStatus)ErrorHelper.createErrorStatus(Messages.AcquireSnapshotAction_UnableToCreateDirectory));
                return true;
            }
        }

        public boolean canFinish() {
            return this.acquireDialog.isPageComplete() && this.argumentsPage.isPageComplete() && this.configPage.isPageComplete();
        }

        public IWizardPage getStartingPage() {
            return this.acquireDialog;
        }

        public void init(IWorkbench workbench, IStructuredSelection selection) {
        }
    }

    public static class Handler
    extends AbstractHandler {
        public Object execute(ExecutionEvent executionEvent) {
            new AcquireSnapshotAction().run();
            return null;
        }
    }
}

