/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.refined;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextDerivedData;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ISelectionProvider;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.refined.RefinedStructuredResult;
import org.eclipse.mat.query.refined.RefinedTable;
import org.eclipse.mat.query.refined.RefinedTree;
import org.eclipse.mat.query.refined.TotalsCalculator;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RefinedResultBuilder {
    RefinedStructuredResult refinedResult;

    public RefinedResultBuilder(IQueryContext context, IStructuredResult subject) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (subject instanceof IResultTable) {
            this.refinedResult = new RefinedTable();
        } else if (subject instanceof IResultTree) {
            this.refinedResult = new RefinedTree();
        } else {
            throw new IllegalArgumentException(MessageUtil.format(Messages.RefinedResultBuilder_Error_UnsupportedType, subject.getClass().getName()));
        }
        this.refinedResult.subject = subject;
        this.refinedResult.context = context;
        this.refinedResult.metaData = subject.getResultMetaData();
        if (this.refinedResult.metaData == null) {
            this.refinedResult.metaData = new ResultMetaData.Builder().build();
        }
        this.refinedResult.iconProvider = subject instanceof IIconProvider ? (IIconProvider)((Object)subject) : IIconProvider.EMPTY;
        this.refinedResult.selectionProvider = subject instanceof ISelectionProvider ? (ISelectionProvider)((Object)subject) : ISelectionProvider.EMPTY;
        this.setColumnData(subject);
        this.addPreConfiguredDerivedColumns(this.refinedResult.metaData);
    }

    private void setColumnData(IStructuredResult structuredResult) {
        Column[] columns = structuredResult.getColumns();
        ContextDerivedData derivedData = this.refinedResult.context.getContextDerivedData();
        boolean foundSortColumn = false;
        int ii = 0;
        while (ii < columns.length) {
            RefinedStructuredResult.ValueAccessor accessor;
            ContextDerivedData.DerivedCalculator calculator = (ContextDerivedData.DerivedCalculator)columns[ii].getData(ContextDerivedData.DerivedCalculator.class);
            if (calculator != null) {
                ContextDerivedData.DerivedColumn derivedColumn = (ContextDerivedData.DerivedColumn)columns[ii].getData(ContextDerivedData.DerivedColumn.class);
                ContextProvider provider = null;
                for (ContextProvider p : this.refinedResult.metaData.getContextProviders()) {
                    String ll = derivedData.labelFor(derivedColumn, p);
                    if (!columns[ii].getLabel().equals(ll)) continue;
                    provider = p;
                }
                if (provider == null) {
                    provider = new DefaultContextProvider(structuredResult);
                }
                accessor = new RefinedStructuredResult.CalculatedColumnAccessor(columns[ii], provider, derivedColumn, calculator);
            } else {
                RefinedStructuredResult refinedStructuredResult = this.refinedResult;
                refinedStructuredResult.getClass();
                accessor = refinedStructuredResult.new RefinedStructuredResult.DefaultValueAccessor(ii);
            }
            this.refinedResult.addColumn(columns[ii], accessor);
            if (!foundSortColumn && columns[ii].getSortDirection() != null) {
                this.refinedResult.setSortOrder(columns[ii], columns[ii].getSortDirection());
                foundSortColumn = true;
            }
            ++ii;
        }
        if (this.refinedResult.metaData.isPreSorted()) {
            this.refinedResult.internalSetSortOrder(this.refinedResult.metaData.getPreSortedColumnIndex(), this.refinedResult.metaData.getPreSortedDirection(), true, null);
        }
    }

    private void addPreConfiguredDerivedColumns(ResultMetaData metaData) {
        Collection<ContextDerivedData.DerivedOperation> derivedOperations = metaData.getDerivedOperations();
        if (derivedOperations == null) {
            return;
        }
        for (ContextDerivedData.DerivedOperation ops : derivedOperations) {
            this.addDefaultContextDerivedColumn(ops);
        }
        for (ContextProvider provider : metaData.getContextProviders()) {
            ContextDerivedData.DerivedOperation[] derivedOperationArray = provider.getOperations();
            int n = derivedOperationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ContextDerivedData.DerivedOperation ops = derivedOperationArray[n2];
                this.addContextDerivedColumn(provider, ops);
                ++n2;
            }
        }
    }

    public int getColumnIndexByName(String columnName) {
        int ii = 0;
        while (ii < this.refinedResult.columns.size()) {
            Column column = this.refinedResult.columns.get(ii);
            if (columnName.equals(column.getLabel())) {
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    public void setSortOrder(int columnIndex, Column.SortDirection direction) {
        if (direction == null) {
            direction = Column.SortDirection.defaultFor(this.refinedResult.columns.get(columnIndex));
        }
        boolean isPreSorted = this.refinedResult.metaData.isPreSorted() && columnIndex == this.refinedResult.metaData.getPreSortedColumnIndex() && direction == this.refinedResult.metaData.getPreSortedDirection();
        this.refinedResult.internalSetSortOrder(columnIndex, direction, isPreSorted, null);
    }

    public void setSortOrder(int[] indices, Column.SortDirection[] directions) {
        if (indices.length != directions.length) {
            throw new IllegalArgumentException(Messages.RefinedResultBuilder_Error_ColumnsSorting);
        }
        if (indices.length == 1) {
            this.setSortOrder(indices[0], directions[0]);
        } else if (indices.length > 1) {
            Column.SortDirection direction = directions[0];
            if (direction == null) {
                direction = Column.SortDirection.defaultFor(this.refinedResult.columns.get(indices[0]));
            }
            ArrayList<Comparator<Object>> comparators = new ArrayList<Comparator<Object>>(indices.length);
            int ii = 0;
            while (ii < indices.length) {
                comparators.add(this.refinedResult.buildComparator(indices[ii], directions[ii]));
                ++ii;
            }
            RefinedStructuredResult.MultiColumnComparator cmp = new RefinedStructuredResult.MultiColumnComparator(comparators);
            this.refinedResult.internalSetSortOrder(indices[0], direction, false, cmp);
        }
    }

    public void addDefaultContextDerivedColumn(ContextDerivedData.DerivedOperation operation) {
        this.addContextDerivedColumn(new DefaultContextProvider(this.refinedResult.subject), operation);
    }

    public void addContextDerivedColumn(ContextProvider provider, ContextDerivedData.DerivedOperation operation) {
        ContextDerivedData.DerivedColumn derivedColumn = this.refinedResult.context.getContextDerivedData().lookup(operation);
        this.refinedResult.addDerivedDataColumn(provider, derivedColumn);
        this.refinedResult.jobs.add(new RefinedStructuredResult.DerivedDataJobDefinition(provider, operation));
    }

    public void setFilter(int columnIndex, String criteria) throws IllegalArgumentException {
        this.refinedResult.filters.get(columnIndex).setCriteria(criteria);
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.refinedResult.columns);
    }

    public void setInlineRetainedSizeCalculation(boolean inline) {
        this.refinedResult.inlineJobs = inline;
    }

    public RefinedStructuredResult build() {
        RefinedStructuredResult result = this.refinedResult;
        this.refinedResult = null;
        result.totalsCalculator = TotalsCalculator.create(result);
        result.init();
        return result;
    }

    private static final class DefaultContextProvider
    extends ContextProvider {
        IStructuredResult result = null;

        private DefaultContextProvider(IStructuredResult result) {
            super((String)null);
            this.result = result;
        }

        public IContextObject getContext(Object row) {
            return this.result.getContext(row);
        }
    }
}

