/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.BytesDisplay;

public class BytesFormat
extends Format {
    private static final long serialVersionUID = 9162983935673281910L;
    private static final double KB = 1024.0;
    private static final double NEGKB = -1024.0;
    private static final double MB = 1048576.0;
    private static final double NEGMB = -1048576.0;
    private static final double GB = 1.073741824E9;
    private static final double NEGGB = -1.073741824E9;
    private static final ThreadLocal<Format> defaultFormat = new ThreadLocal<Format>(){

        @Override
        protected Format initialValue() {
            return DecimalFormat.getInstance();
        }
    };
    private static final ThreadLocal<Format> detailedFormat = new ThreadLocal<Format>(){

        @Override
        protected Format initialValue() {
            return new DecimalFormat(BytesFormat.DETAILED_DECIMAL_FORMAT);
        }
    };
    public static final String DETAILED_DECIMAL_FORMAT = "#,##0.00";
    private final Format encapsulatedNumberFormat;
    private final Format encapsulatedDecimalFormat;

    public BytesFormat() {
        this(null, null);
    }

    public BytesFormat(Format encapsulatedNumberFormat, Format encapsulatedDecimalFormat) {
        this.encapsulatedNumberFormat = encapsulatedNumberFormat;
        this.encapsulatedDecimalFormat = encapsulatedDecimalFormat;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        Long target = null;
        if (obj instanceof Bytes) {
            target = ((Bytes)obj).getValue();
        } else if (obj instanceof Long) {
            target = (Long)obj;
        } else if (obj instanceof Integer) {
            target = ((Integer)obj).longValue();
        } else if (obj instanceof Short) {
            target = ((Short)obj).longValue();
        }
        if (target != null) {
            obj = target;
            BytesDisplay currentDisplay = BytesDisplay.getCurrentValue();
            switch (currentDisplay) {
                case Kilobytes: {
                    return this.formatKb(toAppendTo, target.longValue());
                }
                case Megabytes: {
                    return this.formatMb(toAppendTo, target.longValue());
                }
                case Gigabytes: {
                    return this.formatGb(toAppendTo, target.longValue());
                }
                case Smart: {
                    if ((double)target.longValue() >= 1.073741824E9 || (double)target.longValue() <= -1.073741824E9) {
                        return this.formatGb(toAppendTo, target.longValue());
                    }
                    if ((double)target.longValue() >= 1048576.0 || (double)target.longValue() <= -1048576.0) {
                        return this.formatMb(toAppendTo, target.longValue());
                    }
                    if ((double)target.longValue() >= 1024.0 || (double)target.longValue() <= -1024.0) {
                        return this.formatKb(toAppendTo, target.longValue());
                    }
                    return this.formatB(toAppendTo, target.longValue());
                }
            }
        }
        return this.getDefaultFormat().format(obj, toAppendTo, pos);
    }

    private Format getDefaultFormat() {
        return this.encapsulatedNumberFormat != null ? this.encapsulatedNumberFormat : defaultFormat.get();
    }

    private Format getDetailedFormat() {
        return this.encapsulatedDecimalFormat != null ? this.encapsulatedDecimalFormat : detailedFormat.get();
    }

    private StringBuffer formatGb(StringBuffer toAppendTo, double val) {
        double gb = val / 1.073741824E9;
        toAppendTo.append(String.valueOf(this.getDetailedFormat().format(gb)) + " GB");
        return toAppendTo;
    }

    private StringBuffer formatMb(StringBuffer toAppendTo, double val) {
        double mb = val / 1048576.0;
        toAppendTo.append(String.valueOf(this.getDetailedFormat().format(mb)) + " MB");
        return toAppendTo;
    }

    private StringBuffer formatKb(StringBuffer toAppendTo, double val) {
        double kb = val / 1024.0;
        toAppendTo.append(String.valueOf(this.getDetailedFormat().format(kb)) + " KB");
        return toAppendTo;
    }

    private StringBuffer formatB(StringBuffer toAppendTo, double val) {
        toAppendTo.append(String.valueOf(this.getDefaultFormat().format(val)) + " B");
        return toAppendTo;
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.getDefaultFormat().parseObject(source, pos);
    }

    public static BytesFormat getInstance() {
        return new BytesFormat();
    }
}

