/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.test.plugin.ui;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ConsoleView
extends ViewPart {
    public static final String ID = "org.eclipse.mddi.modelbus.adapter.test.plugin.ui.ConsoleView";
    private TextViewer viewer;
    private Action clearAction = new Action(){

        public void run() {
            ConsoleView.this.doc.set("");
        }
    };
    IDocument doc = new Document();

    public static void displayMessage(Object output) {
        Display d = Display.getDefault();
        d.syncExec((Runnable)new PrintThread(output));
    }

    public void print(Object obj) {
        try {
            String _text = String.valueOf(this.doc.get()) + obj;
            this.doc.set(_text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printException(Exception e) {
        try {
            e.printStackTrace();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter w = new PrintWriter(out);
            w.print(this.doc.get());
            e.printStackTrace(w);
            w.close();
            String _text = out.toString();
            this.doc.set(String.valueOf(_text) + "\n\n");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void createPartControl(Composite parent) {
        try {
            this.viewer = new TextViewer(parent, 770);
            this.viewer.setEditable(false);
            this.viewer.setDocument(this.doc);
            IActionBars bars = this.getViewSite().getActionBars();
            this.fillLocalPullDown(bars.getMenuManager());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void fillLocalPullDown(IMenuManager manager) {
        this.clearAction.setText("clear");
        manager.add((IAction)this.clearAction);
        manager.add((IContributionItem)new Separator());
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public static IViewPart getView(String id) {
        try {
            IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(id);
            return view;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class PrintThread
    implements Runnable {
        Object o;

        PrintThread(Object o) {
            this.o = o;
        }

        public void run() {
            ConsoleView instance = (ConsoleView)ConsoleView.getView(ConsoleView.ID);
            if (instance != null) {
                if (this.o instanceof Exception) {
                    instance.printException((Exception)this.o);
                } else {
                    instance.print(this.o);
                }
            } else {
                System.out.print("Console> " + this.o);
            }
        }
    }
}

