/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.test.serializer;

import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.Serializer;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.Type;

public class CustomSerializer
implements Serializer {
    public String serialize(Parameter param, Object value) throws Exception {
        return value.toString();
    }

    public Object deserialize(Parameter param, String value) throws Exception {
        Type t = param.getType();
        String typeName = t.getName();
        if (t instanceof ModelType) {
            return value;
        }
        if (typeName.equalsIgnoreCase("string")) {
            return value;
        }
        if (typeName.equalsIgnoreCase("integer")) {
            return new Integer(Integer.parseInt(value));
        }
        if (typeName.equalsIgnoreCase("double")) {
            return new Double(Double.parseDouble(value));
        }
        if (typeName.equalsIgnoreCase("boolean")) {
            return Boolean.valueOf(value);
        }
        throw new Exception("Deserialize error, unknown PrimitiveType " + typeName);
    }
}

