/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.notification;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifDelegate;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceClient;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ServerManager;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationConsumer;

public class NotifServiceManager {
    static NotifServiceManager instance = new NotifServiceManager();
    private static Logger logger;
    Map clientMap = new HashMap();
    NotifDelegate notifDelegate = new NotifDelegate();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public static NotifServiceManager getInstance() {
        return instance;
    }

    NotifServiceManager() {
    }

    public void subscribeNotificationConsumer(AdapterStub adapter) throws NotifServiceNotAvailableException {
        String ns_loc = adapter.getProperties().getProperty("notification_service_location");
        if (ns_loc == null) {
            return;
        }
        String topics = adapter.getProperties().getProperty("notification_service_topics");
        if (topics == null) {
            return;
        }
        NotificationConsumer con = adapter.getToolStub().getNotificationConsumer();
        if (con == null) {
            logger.warn((Object)"Tool does not provide NotificationConsumer, so it can not receive notifications");
            return;
        }
        NotifServiceClient c = this.getNotificationServiceClient(ns_loc);
        int port = ServerManager.getModelBusPort(adapter);
        c.subscribeConsumer(port, con, topics);
    }

    public void unsubscribeNotificationConsumer(AdapterStub adapter) throws NotifServiceNotAvailableException {
        String ns_loc = adapter.getProperties().getProperty("notification_service_location");
        if (ns_loc == null) {
            return;
        }
        NotificationConsumer con = adapter.getToolStub().getNotificationConsumer();
        if (con == null) {
            return;
        }
        NotifServiceClient c = this.getNotificationServiceClient(ns_loc);
        c.unsubscribeConsumer(con);
    }

    public Collection getAllNotificationServiceLocations() {
        return new HashSet(this.clientMap.keySet());
    }

    public Collection getAllNotificationServiceClients() {
        return new HashSet(this.clientMap.values());
    }

    public NotifServiceClient getNotificationServiceClient(String location) throws NotifServiceNotAvailableException {
        if (this.clientMap.containsKey(location)) {
            return (NotifServiceClient)this.clientMap.get(location);
        }
        NotifServiceClient client = new NotifServiceClient(location);
        this.clientMap.put(location, client);
        return client;
    }

    public void removeRegistryClient(String location) {
        if (this.clientMap.containsKey(location)) {
            this.clientMap.remove(location);
        }
    }

    public NotifDelegate getNotifDelegate() {
        return this.notifDelegate;
    }
}

