/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi;

import java.io.IOException;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.Serializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Xmi2EmfConversion;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.Type;

public class DefaultSerializer
implements Serializer {
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.DefaultSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public String serialize(Parameter param, Object value) throws Exception {
        Type t = param.getType();
        if (t instanceof ModelType) {
            if (!(value instanceof Collection)) {
                logger.error((Object)("Serialize error, model must be collection - " + param.getName()));
                throw new Exception("Serialize error, model must be collection - " + param.getName());
            }
            return this.serializeModel(value);
        }
        logger.debug((Object)("Non ModelType value:" + t.getName() + " : " + value));
        return value.toString();
    }

    public Object deserialize(Parameter param, String value) throws Exception {
        Type t = param.getType();
        String typeName = t.getName();
        if (t instanceof ModelType) {
            return this.deserializeModel(value);
        }
        if (typeName.equalsIgnoreCase("string")) {
            return value;
        }
        if (typeName.equalsIgnoreCase("integer")) {
            return new Integer(Integer.parseInt(value));
        }
        if (typeName.equalsIgnoreCase("double")) {
            return new Double(Double.parseDouble(value));
        }
        if (typeName.equalsIgnoreCase("boolean")) {
            return Boolean.valueOf(value);
        }
        throw new Exception("Deserialize error, unknown PrimitiveType " + typeName);
    }

    private String serializeModel(Object value) throws IOException {
        Collection model = (Collection)value;
        return Emf2XmiConversion.convertToString(model);
    }

    private Object deserializeModel(String value) throws IOException {
        return Xmi2EmfConversion.convertFromString(value, true);
    }
}

