/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws;

import java.util.List;
import java.util.Properties;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.AbstractInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.AbstractMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.DefaultMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public class DefaultWsInvocationSender
extends AbstractInvocationSender {
    private static Logger logger;
    public SOAPMessage requestMsg;
    public SOAPMessage responseMsg;
    public String targetUrl;
    public Object[] unmarshalledInputs;
    public Object[] unmarshalledOutputs;
    public ModelingService ms;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultWsInvocationSender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public DefaultWsInvocationSender(Properties prop) {
        if (this.getMarshaler() == null) {
            this.setMarshaler(new DefaultMarshaler(prop));
        }
    }

    public Object[] invoke(ModelingService ms, Object[] inputs) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, ModelingServiceError {
        this.targetUrl = DescriptionUtil.getProperty(this.getToolDescription(), "URL");
        this.ms = ms;
        this.unmarshalledInputs = inputs;
        try {
            this.createRequestMessage();
            this.makeConnection();
            this.readResponseMessage();
            return this.unmarshalledOutputs;
        }
        catch (SOAPException e) {
            throw new ModelBusCommunicationException(e.getMessage(), e);
        }
    }

    public void createRequestMessage() throws ModelBusCommunicationException, ModelTypeMismatchException {
        if (this.requestMsg == null) {
            try {
                this.requestMsg = SoapUtil.messageFactory.createMessage();
                SOAPBody requestbody = this.requestMsg.getSOAPBody();
                AbstractMarshaler.setNamespaces(requestbody);
                SOAPElement reqTopElem = requestbody.addChildElement(this.ms.getName(), "modelbus");
                List inputParams = DescriptionUtil.get_in_inout_Parameters(this.ms);
                if (this.unmarshalledInputs.length != inputParams.size()) {
                    throw new ModelTypeMismatchException("Bad number of input parameters, got " + this.unmarshalledInputs.length + " expected " + inputParams.size());
                }
                Parameter[] params = new Parameter[inputParams.size()];
                int i = 0;
                while (i < inputParams.size()) {
                    params[i] = (Parameter)inputParams.get(i);
                    ++i;
                }
                this.getMarshaler().marshal(params, this.unmarshalledInputs, reqTopElem);
            }
            catch (Exception e) {
                throw new ModelBusCommunicationException("Can't create request message", e);
            }
        }
    }

    public void makeConnection() throws SOAPException {
        logger.debug((Object)("Call URL: " + this.targetUrl));
        SOAPConnection con = SoapUtil.connectionFactory.createConnection();
        logger.debug((Object)("Call with Message: " + this.requestMsg.getSOAPBody().toString()));
        this.responseMsg = con.call(this.requestMsg, (Object)this.targetUrl);
        con.close();
        logger.debug((Object)("Response Message: " + this.responseMsg.getSOAPBody().toString()));
    }

    public void readResponseMessage() throws ModelBusCommunicationException, ModelingServiceError {
        SOAPBody responsebody = null;
        try {
            responsebody = this.responseMsg.getSOAPBody();
        }
        catch (SOAPException e1) {
            throw new ModelBusCommunicationException("Can't parse response message", e1);
        }
        if (responsebody.hasFault()) {
            SOAPFault f = responsebody.getFault();
            if (AbstractMarshaler.isModelingServiceError(f)) {
                ModelingServiceError err = AbstractMarshaler.unmarshallModelingServiceError(f);
                throw err;
            }
            throw new ModelBusCommunicationException(String.valueOf(f.toString()) + "[ uri = " + this.targetUrl + "]");
        }
        SOAPElement resTopElem = SoapUtil.getFirstChild((SOAPElement)responsebody);
        if (resTopElem == null) {
            logger.error((Object)"Empty SOAP response");
            logger.debug((Object)responsebody.toString());
            throw new ModelBusCommunicationException("Empty SOAP response");
        }
        List outputParams = DescriptionUtil.get_out_inout_Parameters(this.ms);
        Parameter[] params = new Parameter[outputParams.size()];
        int i = 0;
        while (i < outputParams.size()) {
            params[i] = (Parameter)outputParams.get(i);
            ++i;
        }
        try {
            this.unmarshalledOutputs = this.getMarshaler().unmarshal(params, resTopElem);
        }
        catch (Exception e) {
            throw new ModelBusCommunicationException("Can't unmarshal response message", e);
        }
    }
}

