/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.notification;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotificationServiceUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.SerializedNotification;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.AbstractServer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPoint;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ServerManager;
import org.eclipse.mddi.modelbus.adapter.user.notification.Notification;
import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationConsumer;

public class NotifDelegate
implements EndPoint {
    public static final String END_POINT_ID = "notification";
    Map consumerMap = new Hashtable();
    boolean isServerStarted = false;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    NotifDelegate() {
        EndPointManagerImpl.getInstance().putEndPoint(END_POINT_ID, this);
    }

    public String bindConsumerToServer(int port, NotificationConsumer con) throws Exception {
        String relativePath;
        if (this.consumerMap.containsValue(con)) {
            Iterator it = this.consumerMap.keySet().iterator();
            while (it.hasNext()) {
                relativePath = (String)it.next();
                if (this.consumerMap.get(relativePath) != con) continue;
                return relativePath;
            }
        }
        AbstractServer s = ServerManager.getInstance().getServer(port);
        relativePath = this.createRelativePath(con);
        this.consumerMap.put(relativePath, con);
        String url = "http://" + ServerManager.getHost() + ":" + port + "/" + s.getContext() + "/" + relativePath;
        return url;
    }

    String createRelativePath(NotificationConsumer con) {
        String base = "notification/" + con.getClass().getName();
        int i = 0;
        while (this.consumerMap.containsKey(String.valueOf(base) + i)) {
            ++i;
        }
        String uri = String.valueOf(base) + i;
        return uri;
    }

    public void unbindConsumerToServer(NotificationConsumer con) {
        this.consumerMap.values().remove(con);
    }

    public NotificationConsumer getConsumer(String uri) {
        return (NotificationConsumer)this.consumerMap.get(uri);
    }

    public void execute(String urlpath, SOAPEnvelope req, SOAPEnvelope resp) throws SOAPException {
        NotificationConsumer con = this.getConsumer(urlpath);
        if (con == null) {
            logger.info((Object)("Adapter: received notification for unknown consumer. uri=" + urlpath));
            return;
        }
        SerializedNotification[] rawNotifs = NotificationServiceUtil.extractNotifications(req.getBody());
        int i = 0;
        while (i < rawNotifs.length) {
            Notification notif = new Notification(rawNotifs[i]);
            con.consume(notif);
            ++i;
        }
    }
}

