/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.registry;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ToolSelectionStrategy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.QualifiedServiceName;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ProviderEndPoint;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class DefaultToolSelector
implements ToolSelectionStrategy {
    public Tool selectTool(String serviceName, Collection tools) {
        QualifiedServiceName qname = QualifiedServiceName.getQualifiedServiceName(serviceName);
        Tool t = DefaultToolSelector.findLocalTool(serviceName);
        if (t != null) {
            return t;
        }
        if (tools == null) {
            return null;
        }
        Iterator it = tools.iterator();
        ModelingService ms = null;
        while (it.hasNext() && ms == null) {
            t = (Tool)it.next();
            if (qname.toolName != null && !qname.toolName.equals(t.getName()) || qname.interfaceName != null && !qname.interfaceName.equals(t.getInterface().getName())) continue;
            ms = DescriptionUtil.getServiceDescription(qname.serviceName, t);
        }
        if (ms != null) {
            return t;
        }
        return null;
    }

    public static Tool findLocalTool(String serviceName) {
        QualifiedServiceName qname = QualifiedServiceName.getQualifiedServiceName(serviceName);
        if (qname.toolName != null) {
            Tool testTool;
            ModelingService ms;
            AdapterStub adapter = null;
            String relativePath = ProviderEndPoint.getRelativePath(qname.toolName);
            ProviderEndPoint ep = (ProviderEndPoint)EndPointManagerImpl.getInstance().getEndPoint(relativePath);
            if (ep != null) {
                adapter = ep.getAdapterOfProviderTool(relativePath);
            }
            if (adapter != null && (ms = DescriptionUtil.getServiceDescription(serviceName, testTool = adapter.getToolDescription())) != null) {
                return testTool;
            }
        }
        return null;
    }
}

