/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.AbstractInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.AbstractMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.CopyRestoreFragmentMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public class CopyRestoreFragmentWsInvocationSender
extends AbstractInvocationSender {
    private static Logger logger;
    SOAPMessage requestMsg;
    SOAPMessage responseMsg;
    String targetUrl;
    Object[] unmarshalledInputs;
    Object[] unmarshalledOutputs;
    ModelingService ms;
    Collection inScope = null;
    Collection inoutScope = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultWsInvocationSender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public CopyRestoreFragmentWsInvocationSender(Properties prop) {
        this.setMarshaler(new CopyRestoreFragmentMarshaler(prop));
    }

    public Object[] invoke(ModelingService ms, Object[] inputs) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, ModelingServiceError {
        this.targetUrl = String.valueOf(DescriptionUtil.getProperty(this.getToolDescription(), "URL")) + "." + ms.getName();
        this.ms = ms;
        this.unmarshalledInputs = inputs;
        try {
            this.createRequestMessage();
            this.makeConnection();
            this.readResponseMessage();
            return this.unmarshalledOutputs;
        }
        catch (SOAPException e) {
            throw new ModelBusCommunicationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ModelBusCommunicationException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ModelBusCommunicationException(e.getMessage(), e);
        }
    }

    void createRequestMessage() throws Exception {
        this.requestMsg = SoapUtil.messageFactory.createMessage();
        SOAPBody requestbody = this.requestMsg.getSOAPBody();
        AbstractMarshaler.setNamespaces(requestbody);
        SOAPElement reqTopElem = requestbody.addChildElement(this.ms.getName(), "modelbus");
        List inputParams = DescriptionUtil.get_in_inout_Parameters(this.ms);
        if (this.getCopyRestoreFragmentModelMarshaler().isUseScope()) {
            if (this.unmarshalledInputs.length != inputParams.size() + 2) {
                throw new ModelTypeMismatchException("Bad number of input parameters, got " + this.unmarshalledInputs.length + " expected " + inputParams.size() + " + inScope, outScope");
            }
            this.inScope = (Collection)this.unmarshalledInputs[inputParams.size()];
            if (this.inScope != null) {
                this.getCopyRestoreFragmentModelMarshaler().marshallScope("MODELBUS_IN_SCOPE", this.inScope, reqTopElem);
            }
            this.inoutScope = (Collection)this.unmarshalledInputs[inputParams.size() + 1];
            if (this.inoutScope != null) {
                this.getCopyRestoreFragmentModelMarshaler().marshallScope("MODELBUS_INOUT_SCOPE", this.inoutScope, reqTopElem);
            }
        } else if (this.unmarshalledInputs.length != inputParams.size()) {
            throw new ModelTypeMismatchException("Bad number of input parameters, got " + this.unmarshalledInputs.length + " expected " + inputParams.size());
        }
        int i = 0;
        while (i < inputParams.size()) {
            Parameter p = (Parameter)inputParams.get(i);
            this.getMarshaler().marshal(p, this.unmarshalledInputs[i], reqTopElem);
            ++i;
        }
    }

    private void makeConnection() throws SOAPException {
        logger.debug((Object)("Call URL: " + this.targetUrl));
        SOAPConnection con = SoapUtil.connectionFactory.createConnection();
        logger.debug((Object)("Call with Message: " + this.requestMsg.getSOAPBody().toString()));
        this.responseMsg = con.call(this.requestMsg, (Object)this.targetUrl);
        con.close();
        logger.debug((Object)("Response Message: " + this.responseMsg.getSOAPBody().toString()));
    }

    void readResponseMessage() throws Exception {
        SOAPBody responsebody = this.responseMsg.getSOAPBody();
        if (responsebody.hasFault()) {
            SOAPFault f = responsebody.getFault();
            if (AbstractMarshaler.isModelingServiceError(f)) {
                ModelingServiceError err = AbstractMarshaler.unmarshallModelingServiceError(f);
                throw err;
            }
            throw new ModelBusCommunicationException(f.toString());
        }
        SOAPElement resTopElem = SoapUtil.getFirstChild((SOAPElement)responsebody);
        if (resTopElem == null) {
            logger.error((Object)"Empty SOAP response");
            logger.debug((Object)responsebody.toString());
            throw new ModelBusCommunicationException("Empty SOAP response");
        }
        if (this.getCopyRestoreFragmentModelMarshaler().isUseScope()) {
            this.getCopyRestoreFragmentModelMarshaler().unmarshallScope(resTopElem);
            if (this.inoutScope != null) {
                this.inoutScope.clear();
                this.inoutScope.addAll(this.getCopyRestoreFragmentModelMarshaler().getInoutScope());
            }
        }
        List outputParams = DescriptionUtil.get_out_inout_Parameters(this.ms);
        this.unmarshalledOutputs = new Object[outputParams.size()];
        int i = 0;
        while (i < outputParams.size()) {
            Parameter p = (Parameter)outputParams.get(i);
            this.unmarshalledOutputs[i] = this.getMarshaler().unmarshal(p, resTopElem);
            ++i;
        }
    }

    public CopyRestoreFragmentMarshaler getCopyRestoreFragmentModelMarshaler() {
        return (CopyRestoreFragmentMarshaler)this.getMarshaler();
    }
}

