/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.user.consumer.impl;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.TransportManager;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class GenericConsumerImpl
implements GenericConsumer {
    private static Logger logger;
    AdapterStub adapter;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.user.consumer.impl.GenericConsumerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public GenericConsumerImpl(AdapterStub adapter) {
        this.adapter = adapter;
    }

    public Object[] consume(String serviceName, Object[] parameterValues) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, ModelingServiceError {
        if (parameterValues == null) {
            logger.error((Object)"null inputs");
            throw new ModelTypeMismatchException("null inputs");
        }
        Tool toolDescription = RegistryManager.getInstance().getToolDescription(serviceName, this.adapter);
        if (DescriptionUtil.getIsSessionEnabled(toolDescription)) {
            String[] sessions = this.getOpenSessions(serviceName);
            String sessionId = sessions.length > 0 ? sessions[0] : this.newSession(serviceName);
            return this.consume(serviceName, parameterValues, sessionId);
        }
        ModelingService ms = DescriptionUtil.getServiceDescription(serviceName, toolDescription);
        ProviderProxy sender = this.adapter.getTransportManager().getProviderProxy(toolDescription);
        Object[] outputs = sender.invoke(ms, parameterValues);
        return outputs;
    }

    public void consumeAsync(String serviceName, Object[] parameterValues) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException {
    }

    public boolean isResultReady(String serviceName) {
        return false;
    }

    public Object[] getResult(String serviceName) {
        return null;
    }

    public Object[] consume(String serviceName, Object[] parameterValues, String sessionId) throws ModelingServiceError, ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException {
        if (parameterValues == null) {
            logger.error((Object)"null inputs");
            throw new ModelTypeMismatchException("null inputs");
        }
        Tool toolDescription = RegistryManager.getInstance().getToolDescription(serviceName, this.adapter);
        ModelingService ms = DescriptionUtil.getServiceDescription(serviceName, toolDescription);
        SessionProviderProxy sender = this.adapter.getTransportManager().getSessionProviderProxy(toolDescription);
        Object[] outputs = sender.invoke(ms, parameterValues, sessionId);
        return outputs;
    }

    public String newSession(String serviceName) throws ModelBusCommunicationException, ServiceUnknownException {
        Tool toolDescription = RegistryManager.getInstance().getToolDescription(serviceName, this.adapter);
        SessionProviderProxy proxy = this.adapter.getTransportManager().getSessionProviderProxy(toolDescription);
        String sessionId = proxy.newSession();
        return sessionId;
    }

    public void endSession(String sessionId) throws ModelBusCommunicationException {
        TransportManager tm = this.adapter.getTransportManager();
        SessionManager sm = tm.getSessionManager();
        SessionProviderProxy proxy = sm.getProviderProxy(sessionId);
        logger.debug((Object)("Proxy:" + proxy));
        proxy.endSession(sessionId);
    }

    public String[] getAllOpenSessions() {
        String[] sessions = this.adapter.getTransportManager().getSessionManager().getAllOpenSessions();
        return sessions;
    }

    public String[] getOpenSessions(String serviceName) {
        String[] sessions = this.adapter.getTransportManager().getSessionManager().getOpenSessions(serviceName);
        return sessions;
    }
}

