/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.util;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;
import org.eclipse.uml2.internal.util.UML2URIConverterImpl;

public class UML2Handler
extends SAXXMIHandler {
    public UML2Handler(XMLResource xmiResource, XMLHelper helper, Map options) {
        super(xmiResource, helper, options);
    }

    protected URIConverter getURIConverter() {
        return new UML2URIConverterImpl(super.getURIConverter());
    }

    public void endDocument() {
        super.endDocument();
        if (this.extendedMetaData != null) {
            Iterator demandedPackages = this.extendedMetaData.demandedPackages().iterator();
            while (demandedPackages.hasNext()) {
                URI locationURI;
                EPackage ePackage = (EPackage)demandedPackages.next();
                String nsURI = ePackage.getNsURI();
                if (nsURI == null) continue;
                if (this.urisToLocations != null && (locationURI = (URI)this.urisToLocations.get(nsURI)) != null) {
                    ResourceImpl resource = new ResourceImpl();
                    resource.setURI(locationURI);
                    resource.getContents().add((Object)ePackage);
                }
                Iterator entries = this.helper.getPrefixToNamespaceMap().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = (Map.Entry)entries.next();
                    if (!nsURI.equals(entry.getValue())) continue;
                    ePackage.setNsPrefix((String)entry.getKey());
                }
            }
        }
    }
}

