/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.osgi.framework.Bundle;

public class UML2URIConverterImpl
implements URIConverter {
    private static final String SCHEME_PLATFORM = "platform";
    private static final String SEGMENT_PLUGIN = "plugin";
    private final URIConverter uriConverter;

    public UML2URIConverterImpl(URIConverter uriConverter) {
        this.uriConverter = uriConverter;
    }

    public URI normalize(URI uri) {
        return this.uriConverter.normalize(uri);
    }

    public Map getURIMap() {
        return this.uriConverter.getURIMap();
    }

    /*
     * Unable to fully structure code
     */
    public InputStream createInputStream(URI uri) throws IOException {
        block3: {
            try {
                return this.uriConverter.createInputStream(uri);
            }
            catch (IOException ioe) {
                normalizedURI = this.normalize(uri);
                if (!"platform".equals(normalizedURI.scheme()) || 1 >= normalizedURI.segmentCount() || !"plugin".equals(normalizedURI.segment(0))) break block3;
                platformPluginPath = new StringBuffer();
                i = 1;
                size = normalizedURI.segmentCount();
                ** while (i < size)
            }
lbl-1000:
            // 1 sources

            {
                platformPluginPath.append('/');
                platformPluginPath.append(normalizedURI.segment(i));
                ++i;
                continue;
            }
lbl16:
            // 1 sources

            return this.createPlatformPluginInputStream(platformPluginPath.toString());
        }
        throw ioe;
    }

    public OutputStream createOutputStream(URI uri) throws IOException {
        return this.uriConverter.createOutputStream(uri);
    }

    protected InputStream createPlatformPluginInputStream(String platformPluginPath) throws IOException {
        if (EcorePlugin.getWorkspaceRoot() == null) {
            URI resolvedURI = EcorePlugin.resolvePlatformResourcePath((String)platformPluginPath);
            if (resolvedURI != null) {
                return this.createInputStream(resolvedURI);
            }
            throw new IOException("The path '" + platformPluginPath + "' is not mapped");
        }
        return WorkbenchHelper.createPlatformPluginInputStream(platformPluginPath);
    }

    public static class WorkbenchHelper {
        public static InputStream createPlatformPluginInputStream(String platformPluginPath) throws IOException {
            int segmentIndex = platformPluginPath.indexOf(47, 1);
            int versionIndex = platformPluginPath.substring(0, segmentIndex).lastIndexOf(95);
            String pluginId = platformPluginPath.substring(1, -1 == versionIndex ? segmentIndex : versionIndex);
            Bundle[] bundles = Platform.getBundles((String)pluginId, -1 == versionIndex ? null : platformPluginPath.substring(versionIndex + 1, segmentIndex));
            URL url = null;
            if (bundles != null) {
                url = Platform.find((Bundle)bundles[0], (IPath)new Path(platformPluginPath.substring(segmentIndex + 1)));
            }
            if (url == null) {
                throw new IOException();
            }
            return url.openConnection().getInputStream();
        }
    }
}

