/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 5 juil. 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.test.unit;

import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.DefaultToolSelector;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryClient;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.description.concrete.Tool;


import junit.framework.TestCase;

/**
 * Check that Adapter can communicate with Registry
 * 
 * @author P. Sriplakich
 *
 */
public class RegistryTest extends TestCase {
    
    public static void main(String[] args) {
        junit.textui.TestRunner.run(RegistryTest.class);
    }
    
    String url = "http://localhost:8082/Registry";
    RegistryClient client;
    
    
    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        try {
            //start the registry
            // TODO. replace with Registry of FGH
            BasicRegistry.main(null);
            
            
            client = RegistryManager.getInstance()
            	.getRegistryClient(url);
            
            
        } catch(Exception e) {
            throw new Exception("TestCase can not be initialized", e);
        }
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {

    }        
    
    
    /**
     * Check that the Adapter can register a tool
     */
    public void testRegisterTool() throws RegistryNotAvailableException {
        Tool t = Util.createToolDescription();
        client.registerTool(t);
    }
    
    /**
     * Once register, the tool must be found
     */    
    public void testLookupServices_found() throws RegistryNotAvailableException {
        Tool t = client.lookupToolByModelingService("service1", new DefaultToolSelector());
        assertNotNull(t);
    }

    /**
     * If a no tool provides the specified service, lookup returns null.
     */    
    public void testLookupServices_notFound() throws RegistryNotAvailableException {
        Tool t = client.lookupToolByModelingService("service2", new DefaultToolSelector());
        assertNull(t);
    }
    

}
