/*
 * $RCSfile: CustomSerializer.java,v $
 * $Date: 2006/01/26 14:52:19 $
 * $Revision: 1.1 $
 * $Author: andreys $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * CustomSerializer.java
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.1 $ $Date: 2006/01/26 14:52:19 $
 */
package org.eclipse.mddi.modelbus.adapter.test.serializer;

import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.Serializer;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.Type;

/**
 * 
 * CustomSerializer implementes a dummy serializer that keeps models in a String
 * format
 * 
 */
public class CustomSerializer implements Serializer {

    public CustomSerializer() {
        super();
    }

    public String serialize(Parameter param, Object value) throws Exception {
        //all toString
        return value.toString();
    }

    public Object deserialize(Parameter param, String value) throws Exception {
        Type t = param.getType();
        String typeName = t.getName();
        if (t instanceof ModelType) {
            //do nothing to desirialize
            return (String)value;

        } else {
            if (typeName.equalsIgnoreCase("string")) {
                return value;
            } else if (typeName.equalsIgnoreCase("integer")) {
                return new Integer(Integer.parseInt(value));
            } else if (typeName.equalsIgnoreCase("double")) {
                return new Double(Double.parseDouble(value));
            } else if (typeName.equalsIgnoreCase("boolean")) {
                return Boolean.valueOf(value);
            } else {
                throw new Exception("Deserialize error, unknown PrimitiveType "
                        + typeName);
            }
        }
    }

}
