/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;

public class Emf2XmiConversion {
    static {
        ModelBusResourceSet.init();
    }

    public static String convertToString(Collection emfobjs) throws IOException {
        return Emf2XmiConversion.convertToString(emfobjs, true, true);
    }

    public static String convertToString(Collection emfobjs, boolean skipCrossReferences, boolean skipGlobalResources) throws IOException {
        Set resources = Emf2XmiConversion.getResourcesFromObjects(emfobjs, skipGlobalResources);
        if (!skipCrossReferences) {
            Emf2XmiConversion.addCrossReferencedResources(resources, skipGlobalResources);
        }
        if (resources.size() == 1) {
            Resource r = (Resource)resources.iterator().next();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            r.save((OutputStream)bout, null);
            String s = bout.toString();
            return s;
        }
        throw new IOException("We will support multiple documents transmission soon");
    }

    public static void addCrossReferencedResources(Set resources, boolean skipGlobalResources) {
        Vector<Object> queue = new Vector<Object>();
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            Resource r = (Resource)it.next();
            TreeIterator it2 = r.getAllContents();
            while (it2.hasNext()) {
                EObject containedObject = (EObject)it2.next();
                queue.add(containedObject);
            }
        }
        while (!queue.isEmpty()) {
            EObject o = (EObject)queue.remove(0);
            Iterator it2 = o.eCrossReferences().iterator();
            while (it2.hasNext()) {
                EObject referencedObject = (EObject)it2.next();
                Resource cr = referencedObject.eResource();
                if (resources.contains(cr) || cr == null || skipGlobalResources && ModelBusResourceSet.hasGlobalURIScheme(cr.getURI())) continue;
                resources.add(cr);
                TreeIterator it22 = cr.getAllContents();
                while (it22.hasNext()) {
                    queue.add(it22.next());
                }
            }
        }
    }

    public static Set getResourcesFromObjects(Collection emfobjs, boolean skipGlobalResources) {
        HashSet<Resource> resources = new HashSet<Resource>();
        HashSet<EObject> elemsWithNoResource = new HashSet<EObject>();
        Iterator it = emfobjs.iterator();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            Resource r = o.eResource();
            if (r == null) {
                EObject top = ModelUtil.getTopElement(o);
                elemsWithNoResource.add(top);
                continue;
            }
            if (skipGlobalResources && ModelBusResourceSet.hasGlobalURIScheme(r.getURI())) continue;
            resources.add(r);
        }
        if (resources.size() == 0) {
            ModelBusResourceSet rSet = new ModelBusResourceSet();
            Resource defaultResource = rSet.createResource(ModelBusResourceSet.MB_DEFAULT_RES_URI);
            resources.add(defaultResource);
        }
        Emf2XmiConversion.manageOrphanElement(elemsWithNoResource, resources);
        return resources;
    }

    static void manageOrphanElement(Collection orphanTopElements, Set resources) {
        if (orphanTopElements.isEmpty()) {
            return;
        }
        Resource defaultResource = null;
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            Resource r = (Resource)it.next();
            if (!ModelBusResourceSet.MB_DEFAULT_RES_URI.equals((Object)r.getURI())) continue;
            defaultResource = r;
        }
        if (defaultResource == null) {
            ModelBusResourceSet rSet = new ModelBusResourceSet();
            defaultResource = rSet.createResource(ModelBusResourceSet.MB_DEFAULT_RES_URI);
        }
        defaultResource.getContents().addAll(orphanTopElements);
    }
}

