/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.Serializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.DefaultSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.Marshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.description.abstract_.EnumerationType;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType;
import org.eclipse.mddi.modelbus.description.abstract_.Type;

public abstract class AbstractMarshaler
implements Marshaler {
    private static Logger logger;
    Serializer serializer = new DefaultSerializer();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.AbstractMarshaler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public void marshal(Parameter p, Object parameterValue, SOAPElement topElem) throws Exception {
        if (parameterValue == null) {
            return;
        }
        SOAPElement paramSoapElem = topElem.addChildElement(p.getName());
        if (p.getUpper() != 1) {
            if (!(parameterValue instanceof Object[])) {
                throw new SOAPException("Marshall error, invalid parameter multiplicity - " + p.getName());
            }
            Object[] values = (Object[])parameterValue;
            int i = 0;
            while (i < values.length) {
                Object singleValue = values[i];
                SOAPElement itemElem = paramSoapElem.addChildElement("item");
                this.marshallSingleValue(p, singleValue, itemElem);
                ++i;
            }
        } else {
            this.marshallSingleValue(p, parameterValue, paramSoapElem);
        }
    }

    void marshallSingleValue(Parameter p, Object value, SOAPElement elem) throws Exception {
        Type t = p.getType();
        String serializedObject = this.serializer.serialize(p, value);
        if (t instanceof PrimitiveType) {
            AbstractMarshaler.marshallPrimitiveSingleValue(p, serializedObject, elem);
        } else if (t instanceof EnumerationType) {
            elem.addTextNode(serializedObject);
            elem.setEncodingStyle("modelbus:Enumeration");
        } else if (t instanceof ModelType) {
            this.marshalModel(p, value, elem);
        }
    }

    static void marshallPrimitiveSingleValue(Parameter p, Object value, SOAPElement elem) throws SOAPException {
        block6: {
            Type t = p.getType();
            String typeName = t.getName();
            try {
                if (typeName.equalsIgnoreCase("string")) {
                    elem.setAttribute("xsi:type", "xsd:string");
                    elem.addTextNode((String)value);
                    break block6;
                }
                if (typeName.equalsIgnoreCase("integer")) {
                    elem.setAttribute("xsi:type", "xsd:integer");
                    elem.addTextNode((String)value);
                    break block6;
                }
                if (typeName.equalsIgnoreCase("double")) {
                    elem.setAttribute("xsi:type", "xsd:float");
                    elem.addTextNode((String)value);
                    break block6;
                }
                if (typeName.equalsIgnoreCase("boolean")) {
                    elem.setAttribute("xsi:type", "xsd:boolean");
                    elem.addTextNode((String)value);
                    break block6;
                }
                throw new SOAPException("Marshall error, unknown PrimitiveType " + typeName);
            }
            catch (ClassCastException e) {
                logger.debug((Object)("marshal : " + typeName + ":" + p.getName() + "=" + value + "(" + value.getClass() + ")"));
                throw new SOAPException("Marshall error, invalid primitive type - " + typeName + ":" + p.getName(), (Throwable)e);
            }
        }
    }

    public Object unmarshal(Parameter p, SOAPElement topElem) throws Exception {
        SOAPElement elem = SoapUtil.getChildByLocalName(topElem, p.getName());
        if (elem == null) {
            return null;
        }
        if (p.getUpper() != 1) {
            Vector<Object> values = new Vector<Object>();
            Iterator it = elem.getChildElements();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof SOAPElement)) continue;
                SOAPElement subElem = (SOAPElement)o;
                Object v = this.unmarshallSingleValue(p, subElem);
                values.add(v);
            }
            Object[] array = AbstractMarshaler.getArrayForMultiValueParameter(p, values.size());
            return values.toArray(array);
        }
        return this.unmarshallSingleValue(p, elem);
    }

    static Object[] getArrayForMultiValueParameter(Parameter p, int size) {
        Type t = p.getType();
        if (t instanceof PrimitiveType) {
            String typeName = t.getName();
            if (typeName.equalsIgnoreCase("string")) {
                return new String[size];
            }
            if (typeName.equalsIgnoreCase("integer")) {
                return new Integer[size];
            }
            if (typeName.equalsIgnoreCase("double")) {
                return new Double[size];
            }
            if (typeName.equalsIgnoreCase("boolean")) {
                return new Boolean[size];
            }
            return null;
        }
        if (t instanceof EnumerationType) {
            return new String[size];
        }
        if (t instanceof ModelType) {
            return new Collection[size];
        }
        return null;
    }

    Object unmarshallSingleValue(Parameter p, SOAPElement elem) throws Exception {
        Type t = p.getType();
        String serializedObject = null;
        if (t instanceof PrimitiveType) {
            serializedObject = elem.getValue();
        } else if (t instanceof EnumerationType) {
            String vString;
            serializedObject = vString = elem.getValue();
        } else if (t instanceof ModelType) {
            serializedObject = (String)this.unmarshalModel(p, elem);
        }
        return this.serializer.deserialize(p, serializedObject);
    }

    public static void marshallModelingServiceError(ModelingServiceError err, SOAPFault f) throws SOAPException {
        f.setFaultCode("modelbus:ModelingServiceError");
        f.setFaultString(err.getName());
    }

    public static boolean isModelingServiceError(SOAPFault f) {
        String fcode = f.getFaultCode();
        return fcode.equals("ModelingServiceError");
    }

    public static ModelingServiceError unmarshallModelingServiceError(SOAPFault f) {
        String errName = f.getFaultString();
        ModelingServiceError err = new ModelingServiceError(errName, (Object)null);
        return err;
    }

    public static void setNamespaces(SOAPBody body) throws SOAPException {
        body.addNamespaceDeclaration("xsd", "http://www.w3.org/1999/XMLSchema");
        body.addNamespaceDeclaration("xsi", "http://www.w3.org/1999/XMLSchema-instance");
        body.addNamespaceDeclaration("modelbus", "http://www.eclipse.org/mddi/modelbus");
    }

    public void marshal(Parameter[] params, Object[] parameterValues, SOAPElement topElem) throws Exception {
        if (params == null) {
            return;
        }
        int i = 0;
        while (i < params.length) {
            this.marshal(params[i], parameterValues[i], topElem);
            ++i;
        }
    }

    public Object[] unmarshal(Parameter[] params, SOAPElement topElem) throws Exception {
        if (params == null) {
            return null;
        }
        Object[] unmarshaledParams = new Object[params.length];
        int i = 0;
        while (i < params.length) {
            unmarshaledParams[i] = this.unmarshal(params[i], topElem);
            ++i;
        }
        return unmarshaledParams;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }
}

