/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;

public class ModelUtil {
    public static Collection findElementByType(Collection emfobjs, String typeName) {
        HashSet<EObject> set = new HashSet<EObject>();
        Iterator it = emfobjs.iterator();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            if (!o.eClass().getName().equals(typeName)) continue;
            set.add(o);
        }
        return set;
    }

    public static Collection findElementByType_considerSubtypes(Collection emfobjs, EClass type) {
        HashSet<EObject> set = new HashSet<EObject>();
        Iterator it = emfobjs.iterator();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            if (!ModelUtil.isInstanceOf(o, type)) continue;
            set.add(o);
        }
        return set;
    }

    public static boolean isInstanceOf(EObject o, EClass c) {
        EClass subc = o.eClass();
        if (subc.equals(c)) {
            return true;
        }
        return subc.getEAllSuperTypes().contains((Object)c);
    }

    public static EObject findElementByName(Collection model, String name) {
        Iterator it = model.iterator();
        while (it.hasNext()) {
            Object _name;
            EObject o = (EObject)it.next();
            EStructuralFeature f = o.eClass().getEStructuralFeature("name");
            if (f == null || (_name = o.eGet(f)) == null || !_name.equals(name)) continue;
            return o;
        }
        return null;
    }

    public static EStructuralFeature findStructuralFeature(EClass c, String featureName) {
        EStructuralFeature f = null;
        Iterator it = c.getEAllStructuralFeatures().iterator();
        while (it.hasNext()) {
            f = (EStructuralFeature)it.next();
            if (!f.getName().equals(featureName)) continue;
            return f;
        }
        return null;
    }

    public static Collection flattenHirachicalCollection(Collection model) {
        HashSet<EObject> target = new HashSet<EObject>();
        Iterator it = model.iterator();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            target.add(o);
            TreeIterator it2 = o.eAllContents();
            while (it2.hasNext()) {
                EObject o2 = (EObject)it2.next();
                target.add(o2);
            }
        }
        return target;
    }

    public static Collection getTopElementsFromResources(Resource[] resources) {
        Vector result = new Vector();
        int i = 0;
        while (i < resources.length) {
            Resource r = resources[i];
            result.addAll(r.getContents());
            ++i;
        }
        return result;
    }

    public static Collection getTopElements(Collection model) {
        HashSet<EObject> target = new HashSet<EObject>();
        Iterator it = model.iterator();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            EObject topElem = ModelUtil.getTopElement(o);
            if (target.contains(topElem)) continue;
            target.add(topElem);
        }
        return target;
    }

    public static EObject getTopElement(EObject o) {
        EObject topElem = o;
        while (topElem.eContainer() != null) {
            topElem = topElem.eContainer();
        }
        return topElem;
    }

    public static boolean isEObjectCollection(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof EObject) continue;
            return false;
        }
        return true;
    }

    public static Object getFeatureValue(EObject o, String featureName) {
        EStructuralFeature f = o.eClass().getEStructuralFeature(featureName);
        if (f == null) {
            return null;
        }
        return o.eGet(f);
    }

    public static Object createFromString(String primitiveType, String value) {
        if (primitiveType.equalsIgnoreCase("string")) {
            return value;
        }
        if (primitiveType.equalsIgnoreCase("boolean")) {
            return Boolean.valueOf(value);
        }
        if (primitiveType.equalsIgnoreCase("integer")) {
            return new Integer(Integer.parseInt(value));
        }
        if (primitiveType.equalsIgnoreCase("double")) {
            return new Double(Double.parseDouble(value));
        }
        System.err.println("unknown primitive " + primitiveType);
        return null;
    }

    public static Collection getTopElemsInFragment(Collection fragment) {
        HashSet<EObject> result = new HashSet<EObject>();
        Iterator it = fragment.iterator();
        while (it.hasNext()) {
            EObject e = ModelUtil.getTopElemInFragment((EObject)it.next(), fragment);
            result.add(e);
        }
        return result;
    }

    public static EObject getTopElemInFragment(EObject currentElem, Collection fragment) {
        EObject topElem = currentElem;
        while (topElem.eContainer() != null && fragment.contains(topElem.eContainer())) {
            topElem = topElem.eContainer();
        }
        return topElem;
    }

    public static Adapter findAdapter(Notifier target, Object type) {
        Iterator adapters = target.eAdapters().iterator();
        while (adapters.hasNext()) {
            Adapter adapter = (Adapter)adapters.next();
            if (!adapter.isAdapterForType(type)) continue;
            return adapter;
        }
        return null;
    }

    public static void addCrossReferencedResources(Set resources, Collection ignoredUriPrefixSet) {
        Vector<Object> queue = new Vector<Object>();
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            Resource r = (Resource)it.next();
            TreeIterator it2 = r.getAllContents();
            while (it2.hasNext()) {
                EObject containedObject = (EObject)it2.next();
                queue.add(containedObject);
            }
        }
        while (!queue.isEmpty()) {
            EObject o = (EObject)queue.remove(0);
            Iterator it2 = o.eCrossReferences().iterator();
            while (it2.hasNext()) {
                TreeIterator it22;
                EObject referencedObject = (EObject)it2.next();
                if (referencedObject instanceof EFactory || referencedObject.eIsProxy()) continue;
                Resource cr = referencedObject.eResource();
                if (cr != null && !resources.contains(cr)) {
                    if (ModelUtil.uriBeginsWith(cr.getURI(), ignoredUriPrefixSet)) continue;
                    resources.add(cr);
                    it22 = cr.getAllContents();
                    while (it22.hasNext()) {
                        queue.add(it22.next());
                    }
                    continue;
                }
                if (cr != null) continue;
                cr = null;
                it22 = resources.iterator();
                while (it22.hasNext()) {
                    Resource r = (Resource)it22.next();
                    if (!ModelBusResourceSet.MB_DEFAULT_RES_URI.equals((Object)r.getURI())) continue;
                    cr = r;
                    break;
                }
                if (cr == null) {
                    ModelBusResourceSet rSet = new ModelBusResourceSet();
                    cr = rSet.createResource(ModelBusResourceSet.MB_DEFAULT_RES_URI);
                }
                EObject top = ModelUtil.getTopElement(referencedObject);
                cr.getContents().add((Object)top);
                resources.add(cr);
                TreeIterator it23 = top.eAllContents();
                while (it23.hasNext()) {
                    queue.add(it23.next());
                }
            }
        }
    }

    public static Resource[] getResourcesFromObjects(Collection emfobjs, boolean skipCrossReferences, Collection ignoredUriPrefixSet) {
        Resource r;
        HashSet<Resource> resources = new HashSet<Resource>();
        HashSet<EObject> orphanTopElements = new HashSet<EObject>();
        Iterator it = emfobjs.iterator();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            r = o.eResource();
            if (r == null) {
                EObject top = ModelUtil.getTopElement(o);
                orphanTopElements.add(top);
                continue;
            }
            resources.add(r);
        }
        if (!orphanTopElements.isEmpty()) {
            Resource defaultResource = null;
            Iterator it2 = resources.iterator();
            while (it2.hasNext()) {
                r = (Resource)it2.next();
                if (!ModelBusResourceSet.MB_DEFAULT_RES_URI.equals((Object)r.getURI())) continue;
                defaultResource = r;
                break;
            }
            if (defaultResource == null) {
                ModelBusResourceSet rSet = new ModelBusResourceSet();
                defaultResource = rSet.createResource(ModelBusResourceSet.MB_DEFAULT_RES_URI);
            }
            defaultResource.getContents().addAll(orphanTopElements);
            resources.add(defaultResource);
        }
        if (!skipCrossReferences) {
            ModelUtil.addCrossReferencedResources(resources, ignoredUriPrefixSet);
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    public static boolean uriBeginsWith(URI uri, Collection prefixSet) {
        if (prefixSet == null) {
            return false;
        }
        String uriString = uri.toString();
        Iterator it = prefixSet.iterator();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            if (!uriString.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

