/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.XmiUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.IdTable;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.MBXmiResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ModelSerializer {
    static Logger logger;
    public boolean option_omit_default_value = true;
    Resource mainResource;
    IdTable idTable = null;
    Set fragment = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.ModelSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public ModelSerializer() {
    }

    public ModelSerializer(IdTable t) {
        this.idTable = t;
    }

    public String serializeFragment(Collection fragment) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.serializeFragment(fragment, out);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        return out.toString();
    }

    public void serializeFragment(Collection fragment, OutputStream out) throws IOException {
        Document doc = XmiUtil.createDocument();
        Element docElem = doc.createElementNS("http://www.omg.org/XMI", "xmi:XMI");
        docElem.setAttribute("xmlns:xmi", "http://www.omg.org/XMI");
        doc.appendChild(docElem);
        this.serializeFragment(fragment, docElem);
        XmiUtil.write(docElem, out);
    }

    public void serializeFragment(Collection fragment, Element rootElem) {
        if (fragment.isEmpty()) {
            logger.warn((Object)"fragment is empty");
            return;
        }
        this.fragment = fragment instanceof Set ? (Set)fragment : new HashSet(fragment);
        EObject anObject = (EObject)this.fragment.iterator().next();
        this.mainResource = anObject.eResource();
        if (this.mainResource == null) {
            ModelBusResourceSet rs = new ModelBusResourceSet();
            this.mainResource = rs.createResource(URI.createURI((String)"uri1.mb_xmi"));
        }
        this.initIdTable();
        Document doc = rootElem.getOwnerDocument();
        HashSet<EObject> writtenElems = new HashSet<EObject>();
        Iterator it = this.fragment.iterator();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            EObject top = ModelUtil.getTopElemInFragment(o, this.fragment);
            if (writtenElems.contains(top)) continue;
            EPackage p = top.eClass().getEPackage();
            String uri = p.getNsURI();
            String prefix = p.getNsPrefix();
            rootElem.setAttribute("xmlns:" + prefix, uri);
            Element xmlElem = doc.createElementNS(uri, String.valueOf(prefix) + ":" + top.eClass().getName());
            rootElem.appendChild(xmlElem);
            this.serializeThisElementAndChildren(top, xmlElem);
            writtenElems.add(top);
        }
    }

    public void serializeResource(Resource r, OutputStream out) throws IOException {
        Document doc = XmiUtil.createDocument();
        Element docElem = doc.createElementNS("http://www.omg.org/XMI", "xmi:XMI");
        docElem.setAttribute("xmlns:xmi", "http://www.omg.org/XMI");
        doc.appendChild(docElem);
        this.serializeResource(r, docElem);
        XmiUtil.write(docElem, out);
    }

    public void serializeResource(Resource r, Element rootElem) {
        this.mainResource = r;
        this.initIdTable();
        Iterator it = r.getContents().iterator();
        while (it.hasNext()) {
            Document doc = rootElem.getOwnerDocument();
            EObject top = (EObject)it.next();
            EPackage p = top.eClass().getEPackage();
            String uri = p.getNsURI();
            String prefix = p.getNsPrefix();
            rootElem.setAttribute("xmlns:" + prefix, uri);
            Element xmlElem = doc.createElementNS(uri, String.valueOf(prefix) + ":" + top.eClass().getName());
            rootElem.appendChild(xmlElem);
            this.serializeThisElementAndChildren(top, xmlElem);
        }
    }

    void serializeThisElementAndChildren(EObject o, Element xmlElem) {
        String id = this.getURI(o);
        xmlElem.setAttributeNS("http://www.omg.org/XMI", "xmi:id", id);
        Iterator it = o.eClass().getEAllAttributes().iterator();
        while (it.hasNext()) {
            EAttribute a = (EAttribute)it.next();
            if (a.isDerived() || a.isTransient() || !a.isChangeable()) continue;
            this.serializeAttribute(o, a, xmlElem);
        }
        it = o.eClass().getEAllReferences().iterator();
        while (it.hasNext()) {
            EReference r = (EReference)it.next();
            if (ModelSerializer.omitSerialize(r)) continue;
            this.serializeReference(o, r, xmlElem);
        }
    }

    void serializeAttribute(EObject o, EAttribute a, Element xmlElem) {
        if (!a.isMany()) {
            Object value = o.eGet((EStructuralFeature)a);
            if (!(value == null || this.option_omit_default_value && a.getDefaultValue() != null && value.equals(a.getDefaultValue()))) {
                xmlElem.setAttribute(a.getName(), value.toString());
            }
        } else {
            List values = (List)o.eGet((EStructuralFeature)a);
            Document doc = xmlElem.getOwnerDocument();
            int i = 0;
            while (i < values.size()) {
                Element subXmlElem = doc.createElement(a.getName());
                Object value = values.get(i);
                Text text = doc.createTextNode(value.toString());
                subXmlElem.appendChild(text);
                xmlElem.appendChild(subXmlElem);
                ++i;
            }
        }
    }

    void serializeReference(EObject o, EReference r, Element xmlElem) {
        block6: {
            block7: {
                block4: {
                    block5: {
                        if (!r.isContainment()) break block4;
                        if (r.isMany()) break block5;
                        EObject value = (EObject)o.eGet((EStructuralFeature)r);
                        if (value == null || this.fragment != null && !this.fragment.contains(value)) break block6;
                        this.serializeReferenceValueAsContent(r, value, xmlElem);
                        break block6;
                    }
                    List values = (List)o.eGet((EStructuralFeature)r);
                    int i = 0;
                    while (i < values.size()) {
                        EObject value = (EObject)values.get(i);
                        if (this.fragment == null || this.fragment.contains(value)) {
                            this.serializeReferenceValueAsContent(r, value, xmlElem);
                        }
                        ++i;
                    }
                    break block6;
                }
                if (r.isMany()) break block7;
                EObject value = (EObject)o.eGet((EStructuralFeature)r);
                if (value == null || this.fragment != null && !this.fragment.contains(value)) break block6;
                this.serializeReferenceValueAsLink(o.eResource(), r, value, xmlElem);
                break block6;
            }
            List values = (List)o.eGet((EStructuralFeature)r);
            int i = 0;
            while (i < values.size()) {
                EObject value = (EObject)values.get(i);
                if (this.fragment == null || this.fragment.contains(value)) {
                    this.serializeReferenceValueAsLink(o.eResource(), r, value, xmlElem);
                }
                ++i;
            }
        }
    }

    void serializeReferenceValueAsLink(Resource ownerResource, EReference r, EObject value, Element containerXmlElem) {
        Element subXmlElem = containerXmlElem.getOwnerDocument().createElement(r.getName());
        ModelSerializer.setXmiType(value.eClass(), subXmlElem);
        String idref = this.getURI(value);
        subXmlElem.setAttribute("href", idref);
        containerXmlElem.appendChild(subXmlElem);
    }

    void serializeReferenceValueAsContent(EReference r, EObject value, Element containerXmlElem) {
        Element subXmlElem = containerXmlElem.getOwnerDocument().createElement(r.getName());
        containerXmlElem.appendChild(subXmlElem);
        ModelSerializer.setXmiType(value.eClass(), subXmlElem);
        this.serializeThisElementAndChildren(value, subXmlElem);
    }

    static void setXmiType(EClass type, Element xmlElem) {
        EPackage p = type.getEPackage();
        String uri = p.getNsURI();
        String prefix = p.getNsPrefix();
        xmlElem.setAttributeNS("http://www.omg.org/XMI", "xmi:type", String.valueOf(prefix) + ":" + type.getName());
        Document doc = xmlElem.getOwnerDocument();
        Element root = doc.getDocumentElement();
        root.setAttribute("xmlns:" + prefix, uri);
    }

    static boolean omitSerialize(EReference r) {
        if (r.isDerived() || r.isTransient() || !r.isChangeable() || r.isContainer()) {
            return true;
        }
        if (r.isContainment()) {
            return false;
        }
        EReference op = r.getEOpposite();
        if (op == null) {
            return false;
        }
        if (r.isOrdered()) {
            return false;
        }
        if (op.isOrdered()) {
            return true;
        }
        return r.getName().compareTo(op.getName()) < 0;
    }

    String getURI(EObject o) {
        Resource r = this.getResource(o);
        if (r == this.mainResource) {
            return this.idTable.getOrCreateId(o);
        }
        if (this.fragment != null && this.fragment.contains(o)) {
            return this.idTable.getOrCreateId(o);
        }
        return String.valueOf(r.getURI().toString()) + "#" + r.getURIFragment(o);
    }

    Resource getResource(EObject o) {
        Resource r = o.eResource();
        if (r != null) {
            return r;
        }
        EObject top = ModelUtil.getTopElement(o);
        this.mainResource.getContents().add((Object)top);
        return this.mainResource;
    }

    void initIdTable() {
        if (this.idTable == null) {
            this.idTable = this.mainResource instanceof MBXmiResource ? ((MBXmiResource)this.mainResource).getIdTable() : new IdTable();
        } else if (this.mainResource instanceof MBXmiResource && ((MBXmiResource)this.mainResource).getIdTable() != this.idTable) {
            logger.warn((Object)("the IdTable of " + this.mainResource.getURI() + " is not used"));
        }
    }

    public IdTable getIdTable() {
        return this.idTable;
    }

    public void setIdTable(IdTable idTable) {
        this.idTable = idTable;
    }
}

