/*
 * $RCSfile: ModelWrapper.java,v $
 * $Date: 2006/01/26 14:48:59 $
 * $Revision: 1.1.2.1 $
 * $Author: andreys $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * WPackageRegistry.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1.2.1 $ $Date: 2006/01/26 14:48:59 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;




/**
 * @author P. Sriplakich
 *
 *
 */
public abstract class ModelWrapper {

    
    public abstract EObject wrapModelElement(Object o);
    
    public abstract Object unwrapModelElement(EObject o);

    public abstract boolean canWrap(Object o);
    
    public abstract boolean canUnwrap(Object o);    
    
    public abstract EObject create(EClass c);
    
    ///////////////// static methods
    
    public static final Map registries = new Hashtable(); 

    public static void addRegistry(String format, ModelWrapper r) {
        registries.put(format, r);
    }
    
    public static ModelWrapper getRegistry(String format) {
        return (ModelWrapper) registries.get(format);
    }

    public static Collection wrap(Collection c) {
        if(c==null) return null;
        Collection l = new HashSet();
        if(c.isEmpty()) return new HashSet();
        ModelWrapper reg = null;
        Object o1 = c.iterator().next();
        if(o1 instanceof EObject) {
           // it is already wrapped 
           return new HashSet(c);
        }
        for(Iterator it =registries.values().iterator(); it.hasNext();) {
            ModelWrapper r = (ModelWrapper) it.next();
            if(r.canWrap(o1)) {
                reg = r;
                break;
            }
        }
        if(reg==null) {
          throw new RuntimeException("No wrapper for type " + c.iterator().next().getClass());   
        }
        for(Iterator it = c.iterator(); it.hasNext();) {
            Object o = it.next();
            l.add(reg.wrapModelElement(o));
        }
        return l;
    }

    public static Collection unwrap(Collection c) {
        if(c==null) return null;
        Collection l = new Vector();
        if(c.isEmpty()) {
          return l;
        }
        ModelWrapper reg = null;        
        Object o1 = c.iterator().next();
        for(Iterator it =registries.values().iterator(); it.hasNext();) {
            ModelWrapper r = (ModelWrapper) it.next();
            if(r.canUnwrap(o1)) {
                reg = r;
                break;
            }
        }       
        if(reg==null) {
            throw new RuntimeException("No wrapper for type " + c.iterator().next().getClass());   
        }        
        for(Iterator it=c.iterator(); it.hasNext();) {
            Object o = reg.unwrapModelElement((EObject) it.next());
            l.add(o);
        }
        return l;
    }    
    
    

}
