/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 17 juin 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.notification;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ServerManager;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationConsumer;

/**
 * NotificationServiceClientManager is a container of all
 * NotificationServiceClients. It allows several Adapters (of several tools) to
 * share NotificationServiceClients.
 * 
 * 
 * @author Prawee Sriplakich (LIP6)
 */
public class NotifServiceManager {

    static NotifServiceManager instance = new NotifServiceManager();
    private static Logger logger = Logger.getLogger(NotifServiceManager.class); 
    
    public static NotifServiceManager getInstance() {
        return instance;
    }

    Map clientMap = new HashMap();

    NotifDelegate notifDelegate = new NotifDelegate();

    NotifServiceManager() {
    }

    public void subscribeNotificationConsumer(AdapterStub adapter)
            throws NotifServiceNotAvailableException {
        String ns_loc = adapter.getProperties().getProperty(
                AdapterStub.PROP_NOTIF_LOCATION);
        if (ns_loc == null)
            return;
        String topics = adapter.getProperties().getProperty(
                AdapterStub.PROP_NOTIF_TOPICS);
        if (topics == null)
            return;
        NotificationConsumer con = adapter.getToolStub()
                .getNotificationConsumer();
        if (con == null) {
            logger.warn("Tool does not provide NotificationConsumer, so it can not receive notifications");
            return;
        }
        NotifServiceClient c = getNotificationServiceClient(ns_loc);
        int port = ServerManager.getModelBusPort(adapter);
        c.subscribeConsumer(port, con, topics);
    }

    public void unsubscribeNotificationConsumer(AdapterStub adapter)
            throws NotifServiceNotAvailableException {
        String ns_loc = adapter.getProperties().getProperty(
                AdapterStub.PROP_NOTIF_LOCATION);
        if (ns_loc == null)
            return;
        NotificationConsumer con = adapter.getToolStub()
                .getNotificationConsumer();
        if (con == null) {
            // this tool does not receive notifications
            return;
        }
        NotifServiceClient c = getNotificationServiceClient(ns_loc);
        c.unsubscribeConsumer(con);
    }

    public Collection getAllNotificationServiceLocations() {
        return new HashSet(clientMap.keySet());
    }

    public Collection getAllNotificationServiceClients() {
        return new HashSet(clientMap.values());
    }

    public NotifServiceClient getNotificationServiceClient(String location)
            throws NotifServiceNotAvailableException {
        if (clientMap.containsKey(location)) {
            return (NotifServiceClient) clientMap.get(location);
        }
        NotifServiceClient client = new NotifServiceClient(location);
        clientMap.put(location, client);
        return client;
    }

    public void removeRegistryClient(String location) {
        if (clientMap.containsKey(location)) {
            clientMap.remove(location);
        }
    }

    /**
     * @return Returns the notifDelegate.
     */
    public NotifDelegate getNotifDelegate() {
        return notifDelegate;
    }

}
