/*
 * $RCSfile: MBXmiResource.java,v $
 * $Date: 2006/01/26 14:48:59 $
 * $Revision: 1.1.2.2 $
 * $Author: andreys $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * MBXmiResource.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1.2.2 $ $Date: 2006/01/26 14:48:59 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;


public class MBXmiResource extends ResourceImpl {

    static Logger logger = Logger.getLogger(MBXmiResource.class);
    
    IdTable t;
    
    public MBXmiResource(URI uri, IdTable idTable) {
       super(uri);
       t = idTable;
    }
    
    public MBXmiResource(URI uri) {
        this(uri, new IdTable());
    }
    
    
    
    
    
    protected void doLoad(InputStream in, Map options) throws IOException {
        t.clear();
        ModelDeserializer deser = new ModelDeserializer(this);
      
        try {
            deser.deserialize(in);
        } catch (Exception e) {
            if(e instanceof IOException) throw (IOException)e;
            logger.error(e.toString(), e);
            throw new IOException(e.toString());
        } 
              
    }
    
    
    
    protected void doSave(OutputStream outputStream, Map options) throws IOException {
       ModelSerializer ser = new ModelSerializer(t);
       ser.serializeResource(this, outputStream);
    }    
    
    public IdTable getIdTable() {
        return t;
    }
    
    /* 
     * overide Resource method
     */
    public String getURIFragment(EObject eObject) {
        if(eObject.eResource()!=this) {
            return null;
        }
        return t.getId(eObject);
    }

    /* 
     * overide Resource method
     */    
    public EObject getEObject(String uriFragment) {
        return t.getModelElement(uriFragment);
    }  
    
    
   
    
}
