/**
 * <copyright>
 * </copyright>
 *
 * $Id: ModelTypeImpl.java,v 1.1 2006/01/24 15:43:02 xblanc Exp $
 */
package org.eclipse.mddi.modelbus.description.abstract_.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.mddi.modelbus.description.abstract_.AbstractPackage;
import org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Model Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mddi.modelbus.description.abstract_.impl.ModelTypeImpl#getContent <em>Content</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ModelTypeImpl extends TypeImpl implements ModelType {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.  All rights reserved.This software is published under the terms of the ModelBus Software License in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. A copy of ModelBus Software License is provided with this distribution in doc/LICENSE.txt file.";

    /**
     * The cached value of the '{@link #getContent() <em>Content</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getContent()
     * @generated
     * @ordered
     */
    protected EList content = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ModelTypeImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return AbstractPackage.eINSTANCE.getModelType();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getContent() {
        if (content == null) {
            content = new EObjectContainmentEList(MetaclassSpecification.class, this, AbstractPackage.MODEL_TYPE__CONTENT);
        }
        return content;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case AbstractPackage.MODEL_TYPE__CONTENT:
                    return ((InternalEList)getContent()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case AbstractPackage.MODEL_TYPE__NAME:
                return getName();
            case AbstractPackage.MODEL_TYPE__CONTENT:
                return getContent();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case AbstractPackage.MODEL_TYPE__NAME:
                setName((String)newValue);
                return;
            case AbstractPackage.MODEL_TYPE__CONTENT:
                getContent().clear();
                getContent().addAll((Collection)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case AbstractPackage.MODEL_TYPE__NAME:
                setName(NAME_EDEFAULT);
                return;
            case AbstractPackage.MODEL_TYPE__CONTENT:
                getContent().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case AbstractPackage.MODEL_TYPE__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case AbstractPackage.MODEL_TYPE__CONTENT:
                return content != null && !content.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

} //ModelTypeImpl
