/*
 * $RCSfile: ProfiledModelLoaderTest.java,v $
 * $Date: 2006/01/26 14:52:19 $
 * $Revision: 1.2 $
 * $Author: andreys $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * ProfiledModelLoaderTest.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.2 $ $Date: 2006/01/26 14:52:19 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.test.profile;

import java.io.IOException;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Profile;
import org.eclipse.uml2.util.UML2Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.uml2.Uml2ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Xmi2EmfConversion;

public class ProfiledModelLoaderTest {

    static String umlResourceURI = "jar:file:/D:/eclipse3.1.1/plugins/org.eclipse.uml2.resources_1.1.0.jar!/";
    
    /**
     * main
     * 
     * @param args
     * 
     *
     */

    public static void main(String[] args) throws Exception {
        // TODO Auto-generated method stub
        Uml2ModelUtil.init(URI.createURI(umlResourceURI ));
        // testLoadingProfile();
        //testLoadingUMLResources();
        testProfiledModelDeserialization();
    }
    
    static void testLoadingProfile() throws IOException {
        ResourceSet rs = new ModelBusResourceSet();
        //Resource r1 = rs.createResource(URI.createFileURI("src/com/ibm/uml2/articles/Ecore.profile.uml2") );
        //Resource r2 = rs.createResource(URI.createFileURI("src/com/ibm/uml2/articles/ExtendedPO2_Ecore.uml2") );
        Resource r1 = rs.createResource(URI.createFileURI("src/org/eclipse/mddi/modelbus/adapter/test/profile/MyProfile.profile.uml2") );
        Resource r2 = rs.createResource(URI.createFileURI("src/org/eclipse/mddi/modelbus/adapter/test/profile/MySystem.uml2") );
        r1.load(null);
        r2.load(null);
        Model m = (Model) r2.getContents().get(0);
        
        ProfileSupportedTool.examineProfiledModel(m);
    }

    static void testLoadingUMLResources() throws Exception {
        
        
        //      System.out.println("normalized = "
        //              +ModelBusResourceSet.getGlobalResourceRegistry().getURIConverter().normalize(
        //                      URI.createURI( UML2Resource.UML2_METAMODEL_URI ) ) );     
              
              ResourceSetImpl rs = new ModelBusResourceSet();
              System.out.println(UML2Resource.UML2_METAMODEL_URI);      
              Resource r = rs.getResource(
                      URI.createURI( UML2Resource.UML2_METAMODEL_URI ), true);      
              System.out.println(r.getContents().get(0));
            
            
     }

    // use for standalone testing
    static void testProfiledModelDeserialization() throws IOException {
    
        // Load and register your profile so that it can be managed by ModelBus
        // If the profile is already loaded, use
        // Uml2ModelUtil.registerProfile(prof) instead
        Profile prof = Uml2ModelUtil
                .registerProfile(URI
                        .createFileURI("src/org/eclipse/mddi/modelbus/adapter/test/profile/MyProfile.profile.uml2"));
    
        // If you model has URI1 referencing the profile.
        // Then you need to set Alias : URI1 -> your profile
        // so that ModelBus avoid reloading the same profile twice.
        // Ex. Uml2ModelUtil.setAliasToProfile(
        // URI.createFileURI("src/profile/MyProfile.profile.uml2"), prof);
//        Uml2ModelUtil.setAliasURIToProfile(URI
//                .createFileURI("MyProfile.profile.uml2"), prof);
    
        // load your profiled model.
        // - possible to use other technique than
        // Xmi2EmfConversion.loadFromFile()
        // - The essential is that the linked profile from model
        // and the registerred profile must be the same object.
        Model m = (Model) Xmi2EmfConversion
                .loadFromFile(
                        "src/org/eclipse/mddi/modelbus/adapter/test/profile/MySystem.uml2")
                .get(0);
    
        // test link between the model and the profile
        Uml2ModelUtil.hasLink(m, prof);
    
        // show tag values in the model
        ProfileSupportedTool.examineProfiledModel(m);
    
        // prof.eResource().setURI(URI.createFileURI("src/profile/MyProfile.profile.uml2"));
        // prof.eResource().save(null);
        // m.eResource().save(null);
    }    
}
