/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 14 juin 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.test.sample;


import java.util.Properties;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
//import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.server.WsBindingManager;
import org.eclipse.mddi.modelbus.adapter.test.framework.ProviderTest;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;

/**
 * 
 * Example of the provider tool deployment.
 * The provider tool provides the "createNewClass" service.
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 *  
 */
public class ProviderTestSample {
    

    ProviderTest test;
    Properties prop;
    
    private static Logger logger=Logger.getLogger(ProviderTestSample.class);
    
    public ProviderTestSample(Properties p) {
        LoggerConfigurator.configure();
        prop = p;
    }    

    /**
     * Deploys the provider tool
     * 
     * @throws Exception
     */
    public void runTest() throws Exception {


        AdapterStub adapter = new AdapterStubImpl(prop);

        GenericProvider provider = new SampleModelingServiceImpl(); 
        // GenericSessionProvider ssi = null; 
        // NotificationConsumer nc = null; 

        adapter.getToolStub().setProvider(provider);
        //adapter.getToolStub().setSessionProvider(sessionProvider);
        //adapter.getToolStub().setNotificationConsumer(nc);

        logger.debug("Deploying Adapter");
        test = new ProviderTest(adapter);
        
        test.deploy();
        
    }
    
    public static boolean isStarted = false;
    
    public static void main(String args[]) {

        if(isStarted) return;
        
        String registry_loc;
        if(args.length>0) {
          registry_loc = args[0];
        } else {
          registry_loc = BasicRegistry.getUrl();
        }
        
        String desc_file;
        if(args.length>1) {
            desc_file = args[1];
        } else {
            desc_file = "./src/org/eclipse/mddi/modelbus/adapter/test/sample/sample.description";
        }
        
        try {
            
            Properties p = new Properties();
            
            p.put(AdapterStub.PROP_REGISTRY_LOCATION, registry_loc);
            p.put(AdapterStub.PROP_TOOL_DESC_FILE , desc_file);
            
            ProviderTestSample testSample = new ProviderTestSample(p);
            testSample.runTest();
            logger.info("Provider tool is available");
        } catch (Exception e) {
            e.printStackTrace();
            //WsBindingManager.getInstance().stopAllServers();
            System.exit(0);            
        }


    }
}
