/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 5 juil. 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.test.unit;

import java.io.IOException;
import java.util.Properties;

import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.DeploymentException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.WsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;
import org.eclipse.mddi.modelbus.description.concrete.Property;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

import junit.framework.TestCase;

/**
 * Tests Web Services invocation. It does not take into account Modeling
 * Services.
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * 
 */
public class WsTest extends TestCase {

    private static Logger logger = Logger.getLogger(WsTest.class);

    public static void main(String[] args) {
        LoggerConfigurator.configure();
        junit.textui.TestRunner.run(WsTest.class);
    }

    String goodUri = "http://localhost:8080/MyTool";

    String badUri = "http://localhost:8080/no_tool";

    protected void setUp() throws Exception {
        try {
            // launch Server
            AdapterStub adapter = createAdapter();

            // bind Web Services to a URI

            adapter.deploy();

        } catch (Exception e) {
            throw new Exception("TestCase can not be initialized", e);
        }
    }

    /**
     * createAdapterAdd description
     * 
     * @return
     * @throws IOException
     * @throws DeploymentException
     * 
     */
    private AdapterStub createAdapter() throws DeploymentException {

        // create an adapter
        // override the method getWsInvocationReceiver.
        // So that it does nothing when receving SOAP request.
        AdapterStub adapter = new AdapterStubImpl(new Properties()) {
            public WsInvocationReceiver getWsInvocationReceiver() {
                return new WsInvocationReceiver() {
                    public void process(SOAPEnvelope reqMsg, SOAPEnvelope resMsg) {
                        // do nothing
                    }
                };
            }
        };

        // specify the URL of the tool;
        Tool tool = Util.concreteFactory.createTool();
        Property p = Util.concreteFactory.createProperty();
        p.setName("URL");
        p.setValue(goodUri);
        tool.getProperty().add(p);

        adapter.setToolDescription(tool);

        return adapter;
    }

    public void testInvocation_goodUri() throws SOAPException, IOException {
        SOAPConnection con = SoapUtil.connectionFactory.createConnection();
        SOAPMessage request = SoapUtil.messageFactory.createMessage();
        SOAPMessage response = con.call(request, goodUri);
        con.close();
        logger.info("testInvocation_goodUri:");
        logger.info(response);
        // response must not contain SOAP Fault
        assertFalse(response.getSOAPBody().hasFault());
    }

    /**
     * Tests that the SOAP Fault is return if no tool bound in the URI;
     * 
     * @throws SOAPException
     * @throws IOException
     * 
     */
    public void testInvocation_badUri() throws SOAPException, IOException {
        SOAPConnection con = SoapUtil.connectionFactory.createConnection();
        SOAPMessage request = SoapUtil.messageFactory.createMessage();
        SOAPMessage response = con.call(request, badUri);
        con.close();
        logger.info("testInvocation_badUri:");
        logger.info(response);
        // response must contain SOAP Fault (no tool bound)
        assertTrue(response.getSOAPBody().hasFault());
    }

}
