/*
 * $RCSfile: SampleSessionConsumer.java,v $
 * $Date: 2006/01/26 14:52:19 $
 * $Revision: 1.2 $
 * $Author: andreys $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * SampleSessionConsumer.java Add description 
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.2 $ $Date: 2006/01/26 14:52:19 $
 */
package org.eclipse.mddi.modelbus.adapter.test.deploy;

import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;

/*
 * SampleSessionConsumer
 * 
 */

public class SampleSessionConsumer {
    public static final String addClass = "CustomDeployTool.interface1.addNewClass";

    public static final String openPack = "CustomDeployTool.interface1.openPackage";

    public static AdapterStub adapter;

    public static GenericConsumer consumer;

    private static Logger logger = Logger
            .getLogger(SampleSessionConsumer.class);

    public static Collection model = new Vector(); // model to be used as

    // input. initially empty

    public static String modelToString() {
        String result = new String();
        try {
            result = Emf2XmiConversion.convertToString(model);
            return result;
        } catch (IOException e) {
            return "ERROR";
        }

    }

    public static void addClass(String className, String sessionId)
            throws ModelingServiceError, ServiceUnknownException,
            NoToolAvailableException, ModelTypeMismatchException,
            ModelBusCommunicationException {
        Object[] inputs = new Object[2];

        inputs[0] = className;
        inputs[1] = model;

        Object[] outputs = consumer.consume(addClass, inputs, sessionId);
        model = (Collection) outputs[0];
    }

    /**
     * main Add description
     * 
     * @param args
     * 
     */

    public static void main(String[] args) {

        String registry_loc;
        if (args.length > 0) {
            registry_loc = args[0];
        } else {
            registry_loc = BasicRegistry.getUrl();
        }

        logger.info("Registry location is:" + registry_loc);

        try {
            Properties p = new Properties();
            p.put(AdapterStub.PROP_REGISTRY_LOCATION, registry_loc);

            adapter = new AdapterStubImpl(p);

            consumer = adapter.getGenericConsumer();

            String s1 = consumer.newSession(addClass);
            String s2 = consumer.newSession(addClass);

            consumer.consume(openPack, new Object[] { "Pack1" }, s1);
            consumer.consume(openPack, new Object[] { "Pack2" }, s2);

            for (int count = 0; count < 7; count++) {
                addClass("class A" + count++, s1);
                addClass("class B" + count++, s2);
            }

            consumer.endSession(s1);
            consumer.endSession(s2);

            logger.info("Result:" + modelToString());

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
