/*
 * $RCSfile: DeploymentException.java,v $
 * $Date: 2006/01/26 14:48:59 $
 * $Revision: 1.1.2.1 $
 * $Author: andreys $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * DeploymentException.java  
 * 
 * @author Prawee Sriplakich (LIP6)
 * @version $Revision: 1.1.2.1 $ $Date: 2006/01/26 14:48:59 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure;

import java.io.PrintStream;
import java.util.List;
import java.util.Vector;
/**
 * 
 * DeploymentException
 *
 */
public class DeploymentException extends Exception {

    private static final long serialVersionUID = 5783476298319828068L;
    
    List problems = new Vector();
        
    public DeploymentException() {
    } 
    
    public void addProblem(String message, Exception e) {
      problems.add(new Problem(message, e));
    }
    
    public boolean hasProblems() {
      return !problems.isEmpty();
    }
    
    public void printStackTrace(PrintStream s) { 
        s.println("DeploymentException:");
        for(int i=0; i<problems.size(); i++) {
          Problem p = (Problem) problems.get(i);    
          s.println(p.msg);
          p.ex.printStackTrace(s);
        }
    }
    
    
    public static class Problem {
        String msg;
        Exception ex;
        
        Problem(String _msg, Exception _ex) {
          msg = _msg;
          ex = _ex;
        }
    }
     

}
