/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 13 juin 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.QualifiedServiceName;
import org.eclipse.mddi.modelbus.description.abstract_.DirectionKind;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.concrete.Property;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

/**
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * 
 */
public class DescriptionUtil {

    public static final String IS_SESSION_ENABLED = "IsSessionEnabled";

    /**
     * 
     * getServiceDescription
     * 
     * @param serviceName
     *            the service name which can be qualified or not qualified name =
     *            [tool] . [Interface] . [service] or [Interface] . [service]
     * 
     * Example: Objecteering.ModelEdition.loadModel or ModelEdition.loadModel
     * 
     * @return
     * 
     * 
     */
    public static ModelingService getServiceDescription(String serviceName,
            Tool t) {
        QualifiedServiceName qname = QualifiedServiceName
                .getQualifiedServiceName(serviceName);

        Iterator it = t.getInterface().getService().iterator();
        while (it.hasNext()) {
            ModelingService s = (ModelingService) it.next();
            if (qname.serviceName.equals(s.getName()))
                return s;
        }
        return null;
    }

    /**
     * 
     * isToolEqual Two tools are considered equal if tool names, interface names
     * and modelling service names match.
     * 
     * @param t1
     * @param t2
     * @return
     * 
     */
    public static boolean isToolEqual(Tool t1, Tool t2) {
        if ((t1.getName().equals(t2.getName()))
                && (t1.getInterface().getName().equals(t2.getInterface()
                        .getName()))) {
            Iterator it = t1.getInterface().getService().iterator();

            while (it.hasNext()) {
                ModelingService testService = (ModelingService) it.next();
                ModelingService matchingService = DescriptionUtil
                        .getServiceDescription(testService.getName(), t2);
                if (matchingService == null)
                    return false;

            }
            return true;
        }

        return false;
    }

    public static List get_in_inout_Parameters(ModelingService ms) {
        DirectionKind[] dk = { DirectionKind.IN_LITERAL,
                DirectionKind.INOUT_LITERAL };
        return getParameters(ms, dk);
    }

    public static List get_out_inout_Parameters(ModelingService ms) {
        DirectionKind[] dk = { DirectionKind.OUT_LITERAL,
                DirectionKind.RETURN_LITERAL, DirectionKind.INOUT_LITERAL };
        return getParameters(ms, dk);
    }

    public static List getInParameters(ModelingService ms) {
        DirectionKind[] dk = { DirectionKind.IN_LITERAL };
        return getParameters(ms, dk);
    }

    public static List getOutParameters(ModelingService ms) {
        DirectionKind[] dk = { DirectionKind.OUT_LITERAL };
        return getParameters(ms, dk);
    }

    public static List getInoutParameters(ModelingService ms) {
        DirectionKind[] dk = { DirectionKind.INOUT_LITERAL };
        return getParameters(ms, dk);
    }

    public static List getParameters(ModelingService ms, DirectionKind[] dk) {
        List result = new Vector();
        Iterator it = ms.getParameter().iterator();
        while (it.hasNext()) {
            Parameter p = (Parameter) it.next();
            for (int i = 0; i < dk.length; i++) {
                if (p.getDirection().equals(dk[i])) {
                    result.add(p);
                }
            }
        }
        return result;
    }

    public static Parameter getParameter(ModelingService ms, String paramName) {
        Iterator it = ms.getParameter().iterator();
        while (it.hasNext()) {
            Parameter p = (Parameter) it.next();
            if (paramName.equals(p.getName())) {
                return p;
            }
        }
        return null;
    }

    public static String getProperty(Tool t, String propertyName) {
        Iterator it = t.getProperty().iterator();
        while (it.hasNext()) {
            Property p = (Property) it.next();
            if (p.getName().equalsIgnoreCase(propertyName)) {
                return p.getValue();
            }
        }
        return null;
    }

    public static Property getPropertyObject(Tool t, String propertyName) {
        Iterator it = t.getProperty().iterator();
        while (it.hasNext()) {
            Property p = (Property) it.next();
            if (p.getName().equalsIgnoreCase(propertyName)) {
                return p;
            }
        }
        return null;
    }

    public static boolean getIsSessionEnabled(Tool t) {
        String pro = getProperty(t, IS_SESSION_ENABLED);
        if (pro == null)
            return false;
        if (pro.startsWith("true"))
            return true;
        else
            return false;
    }
    
    public static void importAllMetamodels(Tool t){
        Resource r = t.eResource();
        Set s = new HashSet();
        s.add(r);
        Emf2XmiConversion.addCrossReferencedResources(s, true);
        for(Iterator it = s.iterator(); it.hasNext(); ) {
            Resource r2 = (Resource) it.next();
            if(r2==r) continue;
            r.getContents().addAll( r2.getContents());
        }

    }

}
