/*
 * $RCSfile: Serializer.java,v $
 * $Date: 2006/01/26 14:48:59 $
 * $Revision: 1.1.2.1 $
 * $Author: andreys $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * Serializer.java defines signatures for prameter serialisation methods
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.1.2.1 $ $Date: 2006/01/26 14:48:59 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize;

import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

/*
 * Serializer
 * 
 */

public interface Serializer {
    /**
     * serialize defines procedure for serialisation of parameters 
     * 
     * @param param contains parameter type information 
     * according to ModelBus model
     * @param value to serialize
     * @throws Exception
     * @return serializedValue
     *
     */
    public String serialize(Parameter param, Object value) throws Exception;
    
    /**
     * 
     * deserialize defines procedure for deserialisation of parameters 
     * 
     * @param param contains parameter type information 
     * according to ModelBus model
     * @param value to deserialize
     * @throws Exception
     * @return deserializedValue
     *
     */
    public Object deserialize(Parameter param, String value) throws Exception;
}
