/*
 * $RCSfile: LocalSessionInvocationSender.java,v $
 * $Date: 2006/01/26 14:48:59 $
 * $Revision: 1.1.2.3 $
 * $Author: andreys $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * LocalSessionInvocationSender.java
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.1.2.3 $ $Date: 2006/01/26 14:48:59 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.local;

import java.util.Properties;

import javax.xml.soap.SOAPException;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultSessionWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ProviderEndPoint;

public class LocalSessionInvocationSender extends
        DefaultSessionWsInvocationSender {

    private static Logger logger = Logger
            .getLogger(LocalSessionInvocationSender.class);

    public LocalSessionInvocationSender(Properties prop) {
        super(prop);
    }

    public void makeConnection() throws SOAPException {

        logger.debug("Local Call");

        String relativePath = ProviderEndPoint
                .getRelativePath(getToolDescription().getName());

        ProviderEndPoint ep = (ProviderEndPoint) EndPointManagerImpl
                .getInstance().getEndPoint(relativePath);

        logger.debug("Call with Message: "
                + requestMsg.getSOAPBody().toString());

        responseMsg = SoapUtil.messageFactory.createMessage();

        ep.execute(relativePath, requestMsg.getSOAPPart().getEnvelope(),
                responseMsg.getSOAPPart().getEnvelope());

        logger.debug("Response Message: "
                + responseMsg.getSOAPBody().toString());

    }

}
