/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.test.registry;

import java.util.Vector;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPoint;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ServerManager;

public class BasicRegistry
implements EndPoint {
    public static final String REL_PATH = "modelwareRegistry";
    private static Logger logger;
    private static int port;
    private static Vector data;
    public static boolean isStarted;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        port = 8082;
        data = new Vector();
        isStarted = false;
    }

    public static String getUrl() {
        return "http://localhost:" + port + "/" + "modelbus" + "/" + REL_PATH;
    }

    public static void start(int _port) throws Exception {
        port = _port;
        BasicRegistry.start();
    }

    public static void start() throws Exception {
        LoggerConfigurator.configure();
        if (isStarted) {
            return;
        }
        isStarted = true;
        BasicRegistry r = new BasicRegistry();
        ServerManager.getInstance().getServer(port);
        EndPointManagerImpl.getInstance().putEndPoint(REL_PATH, (EndPoint)r);
        logger.info((Object)"Registry is running");
    }

    public static void stop() {
    }

    public void execute(String urlPath, SOAPEnvelope request, SOAPEnvelope response) throws SOAPException {
        SOAPBody requestbody = request.getBody();
        logger.debug((Object)("Request: " + request));
        SOAPElement reqTopElem = SoapUtil.getFirstChild((SOAPElement)requestbody);
        String serviceName = reqTopElem.getLocalName();
        SOAPBody responsebody = response.getBody();
        responsebody.addNamespaceDeclaration("reg", "http://impl.registry.modelware");
        if (serviceName.equalsIgnoreCase("ToolInstance")) {
            String value = reqTopElem.getValue();
            data.add(value);
            logger.debug((Object)value);
            responsebody.addChildElement("registerToolReturn", "registerToolReponse");
        } else if (serviceName.equalsIgnoreCase("lookupAllModelingServices") || serviceName.equalsIgnoreCase("lookupModelingServicesByName") || serviceName.equalsIgnoreCase("lookupAllModelingServiceInterfaces") || serviceName.equalsIgnoreCase("modelingServiceInterfaceName")) {
            SOAPElement paramElem = responsebody.addChildElement("lookupAllModelingServiceInterfacesReturn");
            int i = 0;
            while (i < data.size()) {
                SOAPElement itemElem = paramElem.addChildElement("item");
                itemElem.addTextNode((String)data.get(i));
                ++i;
            }
        } else if (!serviceName.equalsIgnoreCase("deregisterTool")) {
            SOAPFault f = responsebody.addFault();
            f.setFaultString("Registry: unsupported service " + serviceName);
            logger.error((Object)("Registry: unsupported service " + serviceName));
        }
    }

    public static void main(String[] args) {
        LoggerConfigurator.configure();
        if (args == null && args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        try {
            BasicRegistry.start();
        }
        catch (Exception e) {
            logger.error((Object)"Registry was not started:", (Throwable)e);
            System.exit(1);
        }
    }
}

