/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.AbstractMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.DefaultSessionMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public class DefaultSessionWsInvocationSender
extends DefaultWsInvocationSender
implements SessionProviderProxy {
    public static final String NEW_SESSION_TAG = "newSession";
    public static final String END_SESSION_TAG = "endSession";
    private static Logger logger;
    private SessionManager sessionManager;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultSessionWsInvocationSender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public DefaultSessionWsInvocationSender(Properties prop) {
        super(prop);
        this.setMarshaler(new DefaultSessionMarshaler(prop));
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public String newSession() throws ModelBusCommunicationException {
        this.targetUrl = DescriptionUtil.getProperty(this.getToolDescription(), "URL");
        try {
            this.createNewSessionRequest();
            this.makeConnection();
            this.readNewSessionResponse();
        }
        catch (Exception e) {
            logger.error((Object)"Can't make newSession", (Throwable)e);
            throw new ModelBusCommunicationException("Can't make newSession", e);
        }
        String sessionId = ((DefaultSessionMarshaler)this.getMarshaler()).getSessionId();
        this.sessionManager.putProviderProxy(sessionId, this);
        return sessionId;
    }

    public void endSession(String sessionId) throws ModelBusCommunicationException {
        this.targetUrl = DescriptionUtil.getProperty(this.getToolDescription(), "URL");
        try {
            this.createEndSessionRequest();
            this.makeConnection();
            this.readEndSessionResponse();
        }
        catch (Exception e) {
            logger.error((Object)"Can't make endSession", (Throwable)e);
            throw new ModelBusCommunicationException("Can't make endSession", e);
        }
        this.sessionManager.removeSession(sessionId);
    }

    public String[] getOpenSessions() {
        return this.sessionManager.getOpenSessions(String.valueOf(this.getToolDescription().getName()) + "." + this.getToolDescription().getInterface().getName() + ".*");
    }

    public Object[] invoke(ModelingService ms, Object[] inputs, String sessionID) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, ModelingServiceError {
        ((DefaultSessionMarshaler)this.getMarshaler()).setSessionId(sessionID);
        try {
            return this.invoke(ms, inputs);
        }
        catch (Exception e) {
            throw new ModelBusCommunicationException("Can't invoke serivce at:" + this.targetUrl, e);
        }
    }

    public void createNewSessionRequest() throws SOAPException {
        this.requestMsg = SoapUtil.messageFactory.createMessage();
        SOAPBody requestbody = this.requestMsg.getSOAPBody();
        AbstractMarshaler.setNamespaces(requestbody);
        requestbody.addChildElement(NEW_SESSION_TAG, "modelbus");
    }

    public void readNewSessionResponse() throws Exception {
        SOAPBody responsebody = this.responseMsg.getSOAPBody();
        if (responsebody.hasFault()) {
            SOAPFault f = responsebody.getFault();
            if (AbstractMarshaler.isModelingServiceError(f)) {
                ModelingServiceError err = AbstractMarshaler.unmarshallModelingServiceError(f);
                throw err;
            }
            throw new ModelBusCommunicationException(String.valueOf(f.toString()) + "[ uri = " + this.targetUrl + "]");
        }
        SOAPElement resTopElem = SoapUtil.getFirstChild((SOAPElement)responsebody);
        if (resTopElem == null) {
            logger.error((Object)"Empty SOAP response");
            logger.debug((Object)responsebody.toString());
            throw new ModelBusCommunicationException("Empty SOAP response");
        }
        this.getMarshaler().unmarshal((Parameter[])null, resTopElem);
    }

    public void createEndSessionRequest() throws Exception {
        this.requestMsg = SoapUtil.messageFactory.createMessage();
        SOAPBody requestbody = this.requestMsg.getSOAPBody();
        AbstractMarshaler.setNamespaces(requestbody);
        SOAPElement reqTopElem = requestbody.addChildElement(END_SESSION_TAG, "modelbus");
        this.getMarshaler().marshal(null, null, reqTopElem);
    }

    public void readEndSessionResponse() throws SOAPException, IOException, ModelingServiceError, ModelBusCommunicationException {
        SOAPBody responsebody = this.responseMsg.getSOAPBody();
        if (responsebody.hasFault()) {
            SOAPFault f = responsebody.getFault();
            if (AbstractMarshaler.isModelingServiceError(f)) {
                ModelingServiceError err = AbstractMarshaler.unmarshallModelingServiceError(f);
                throw err;
            }
            throw new ModelBusCommunicationException(String.valueOf(f.toString()) + "[ uri = " + this.targetUrl + "]");
        }
    }

    public static void main(String[] args) {
        Properties p = null;
        DefaultSessionWsInvocationSender sender = new DefaultSessionWsInvocationSender(p);
        try {
            sender.createNewSessionRequest();
            System.out.println("New Req:" + sender.requestMsg.getSOAPBody().toString());
            ((DefaultSessionMarshaler)sender.getMarshaler()).setSessionId("AAAA");
            sender.createEndSessionRequest();
            System.out.println("End Req:" + sender.requestMsg.getSOAPBody().toString());
            String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"\n                   xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n                   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n <soapenv:Body>\n <modelbus:newSessionResponse xmlns:modelbus=\"http://www.modelware-ist.org/modelbus\"><modelbus:sessionId>BBBBB</modelbus:sessionId></modelbus:newSessionResponse>\n </soapenv:Body>\n</soapenv:Envelope>";
            MessageFactory mf = MessageFactory.newInstance();
            sender.responseMsg = mf.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(xmlString.getBytes()));
            sender.readNewSessionResponse();
            System.out.println("newSession Read sessionId:" + ((DefaultSessionMarshaler)sender.getMarshaler()).getSessionId());
            xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"\n                   xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n                   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n <soapenv:Body>\n <modelbus:endSessionResponse xmlns:modelbus=\"http://www.modelware-ist.org/modelbus\"><modelbus:sessionId>CCCCCC</modelbus:sessionId></modelbus:endSessionResponse>\n </soapenv:Body>\n</soapenv:Envelope>";
            mf = MessageFactory.newInstance();
            sender.responseMsg = mf.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(xmlString.getBytes()));
            sender.readNewSessionResponse();
            System.out.println("endSession Read sessionId:" + ((DefaultSessionMarshaler)sender.getMarshaler()).getSessionId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

