/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.test.unit;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.description.DescriptionFactory;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.AbstractFactory;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl;
import org.eclipse.mddi.modelbus.description.concrete.ConcreteFactory;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.description.concrete.impl.ConcretePackageImpl;
import org.eclipse.mddi.modelbus.description.impl.DescriptionPackageImpl;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.UML2Factory;
import org.eclipse.uml2.impl.UML2PackageImpl;

public class Util {
    private static Logger logger;
    public static AbstractFactory abstractFactory;
    public static ConcreteFactory concreteFactory;
    public static DescriptionFactory descFactory;
    static /* synthetic */ java.lang.Class class$0;

    static {
        java.lang.Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = java.lang.Class.forName("org.eclipse.mddi.modelbus.adapter.test.unit.Util");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((java.lang.Class)clazz);
        abstractFactory = AbstractPackageImpl.init().getAbstractFactory();
        concreteFactory = ConcretePackageImpl.init().getConcreteFactory();
        descFactory = DescriptionPackageImpl.init().getDescriptionFactory();
    }

    public static Collection createEcoreModel() {
        Vector<EPackage> model = new Vector<EPackage>();
        EcoreFactory factory = EcorePackageImpl.init().getEcoreFactory();
        int i = 0;
        while (i < 5) {
            EPackage p = factory.createEPackage();
            p.setName("P" + i);
            EClass c = factory.createEClass();
            c.setName("Class" + i);
            p.getEClassifiers().add((Object)c);
            model.add(p);
            ++i;
        }
        logger.info((Object)("Created model size:" + model.size()));
        return model;
    }

    public static Collection createUml2Model() {
        Vector<Object> model = new Vector<Object>();
        UML2Factory factory = UML2PackageImpl.init().getUML2Factory();
        int i = 0;
        while (i < 5) {
            Package p = factory.createPackage();
            p.setName("P" + i);
            model.add(p);
            Class c = factory.createClass();
            c.setName("Class" + i);
            p.getOwnedMembers().add((Object)c);
            model.add(c);
            ++i;
        }
        try {
            logger.info((Object)("Created model:" + Emf2XmiConversion.convertToString(model)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static Tool createToolDescription() {
        Tool tool = concreteFactory.createTool();
        tool.setName("Tool1");
        ModelingServiceInterface msi = abstractFactory.createModelingServiceInterface();
        msi.setName("ModelingServiceInterface1");
        ModelingService ms = abstractFactory.createModelingService();
        ms.setName("service1");
        msi.getService().add((Object)ms);
        tool.setInterface(msi);
        ModelBusPackaging p = descFactory.createModelBusPackaging();
        p.getContent().add((Object)tool);
        p.getContent().add((Object)msi);
        return tool;
    }

    public static boolean compareModels(Collection model1, Collection model2) {
        if (model1.size() != model2.size()) {
            logger.info((Object)("size not equal:" + model1.size() + "!=" + model2.size()));
            return false;
        }
        Iterator it = model1.iterator();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            EStructuralFeature f = o.eClass().getEStructuralFeature("name");
            if (f == null) break;
            String name = (String)o.eGet(f);
            boolean found = false;
            Iterator it2 = model2.iterator();
            while (it2.hasNext()) {
                String name2;
                EObject o2 = (EObject)it2.next();
                if (o.eClass().equals(o2.eClass()) && (found = name.equals(name2 = (String)o2.eGet(f)))) break;
            }
            if (found) continue;
            LoggerConfigurator.configure();
            logger.info((Object)("element not found " + name));
            return false;
        }
        return true;
    }

    public static Collection getUmlSequenceDiagramModel() {
        return null;
    }
}

