/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.registry;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.GlobalResourceRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ToolSelectionStrategy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ws.AlreadyRegistered;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ws.WebRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ws.WebRegistryServiceLocator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Xmi2EmfConversion;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class RegistryClient {
    String registry_location;
    WebRegistry registry;
    private static Logger logger;
    Collection tools = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public RegistryClient(String _registry_location) throws RegistryNotAvailableException {
        LoggerConfigurator.configure();
        try {
            this.registry_location = _registry_location;
            WebRegistryServiceLocator loc = new WebRegistryServiceLocator();
            this.registry = loc.getWebRegistry(new URL(this.registry_location));
        }
        catch (Exception e) {
            throw new RegistryNotAvailableException("URL= " + this.registry_location, e);
        }
    }

    public Tool lookupToolByModelingService(String serviceName, ToolSelectionStrategy selector) throws RegistryNotAvailableException {
        Tool t = selector.selectTool(serviceName, null);
        if (t != null) {
            return t;
        }
        if (this.tools != null) {
            t = selector.selectTool(serviceName, this.tools);
        }
        if (t != null) {
            return t;
        }
        this.loadDescriptionsFromRegistry();
        t = selector.selectTool(serviceName, this.tools);
        return t;
    }

    public Collection getCachedToolDescription() throws RegistryNotAvailableException {
        if (this.tools == null) {
            this.loadDescriptionsFromRegistry();
        }
        return this.tools;
    }

    public void loadDescriptionsFromRegistry() throws RegistryNotAvailableException {
        this.tools = new HashSet();
        try {
            String[] results = this.registry.lookupAllModelingServiceInterfaces();
            Collection col = this.toEmf(results);
            Collection modelingServiceInterfaces = ModelUtil.findElementByType(col, "ModelingServiceInterface");
            Iterator it = modelingServiceInterfaces.iterator();
            while (it.hasNext()) {
                ModelingServiceInterface interf = (ModelingServiceInterface)it.next();
                results = this.registry.lookupToolsByModelingServiceInterface(interf.getName());
                col = this.toEmf(results);
                Collection _tools = ModelUtil.findElementByType(col, "Tool");
                this.tools.addAll(_tools);
                RegistryClient.registerResources(_tools);
            }
        }
        catch (Exception e) {
            if (e instanceof AxisFault) {
                logger.error((Object)("Looking up: " + ((AxisFault)e).dumpToString()));
                throw new RegistryNotAvailableException("URL= " + this.registry_location, e);
            }
            throw new RegistryNotAvailableException("URL= " + this.registry_location, e);
        }
    }

    private Collection toEmf(String[] results) throws IOException {
        logger.debug((Object)"Registry lookup result: ");
        int i = 0;
        while (i < results.length) {
            logger.debug((Object)results[i]);
            ++i;
        }
        Vector<String> strings = new Vector<String>();
        int i2 = 0;
        while (i2 < results.length) {
            strings.add(results[i2]);
            ++i2;
        }
        Collection emfobjs = new Xmi2EmfConversion().convertFromStrings(strings, false);
        return emfobjs;
    }

    public String registerTool(Tool desc) throws RegistryNotAvailableException {
        String token = new String();
        try {
            Vector<Tool> emfobjs = new Vector<Tool>();
            emfobjs.add(desc);
            String s = Emf2XmiConversion.convertToString(emfobjs);
            token = this.registry.registerTool(s);
            return token;
        }
        catch (Exception e) {
            if (e instanceof AlreadyRegistered) {
                logger.warn((Object)"Registering: Modeling Service is already registred");
                return token;
            }
            if (e instanceof AxisFault) {
                logger.error((Object)("Registry not available: " + ((AxisFault)e).dumpToString()));
                throw new RegistryNotAvailableException("URL= " + this.registry_location, e);
            }
            logger.error((Object)"Registry not available");
            throw new RegistryNotAvailableException("URL= " + this.registry_location, e);
        }
    }

    public void deregisterTool(String token) throws RegistryNotAvailableException {
        try {
            this.registry.deregisterTool(token);
        }
        catch (Exception e) {
            throw new RegistryNotAvailableException("URL= " + this.registry_location, e);
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public Collection getTools() {
        return this.tools;
    }

    public static void registerResources(Tool tool) {
        Vector<Tool> model = new Vector<Tool>();
        model.add(tool);
        Resource[] res = ModelUtil.getResourcesFromObjects(model, false, GlobalResourceRegistry.GLOBAL_URI_PREFIX_SET);
        int j = 0;
        while (j < res.length) {
            Resource r = res[j];
            int i = 0;
            while (i < r.getContents().size()) {
                if (r.getContents().get(i) instanceof EPackage) {
                    EPackage p = (EPackage)r.getContents().get(i);
                    logger.debug((Object)("Package to register:" + p));
                    ModelBusResourceSet.registerEPackage(p);
                }
                ++i;
            }
            ++j;
        }
    }

    public static void registerResources(Collection tools) {
        Iterator it = tools.iterator();
        while (it.hasNext()) {
            Tool t = (Tool)it.next();
            RegistryClient.registerResources(t);
        }
    }
}

