/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelWrapper;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.IdTable;

public class UpdaterByCopy {
    String format = "EMF";
    IdTable originalModelIdTable;
    Collection originalFragment;
    IdTable updatedCopyIdTable;
    Collection updatedFragment;
    Collection resultFragment = new HashSet();
    Collection resultFragmentIds;
    Collection addedElementIds;
    Collection removedElementIds;

    public UpdaterByCopy(IdTable _originalModelIdTable, Collection _originalFragment, IdTable _updatedCopyIdTable, Collection _updatedFragment) {
        this.originalModelIdTable = _originalModelIdTable;
        this.originalFragment = _originalFragment;
        this.updatedCopyIdTable = _updatedCopyIdTable;
        this.updatedFragment = _updatedFragment;
        this.setFormat("EMF");
    }

    public void update() {
        String id;
        List originalModelIds = this.originalModelIdTable.getIdsFromFragment(this.originalFragment);
        this.resultFragmentIds = this.updatedCopyIdTable.getIdsFromFragment(this.updatedFragment);
        this.addedElementIds = new HashSet(this.resultFragmentIds);
        this.addedElementIds.removeAll(originalModelIds);
        this.removedElementIds = this.originalModelIdTable.getIdsFromFragment(this.originalFragment);
        this.removedElementIds.removeAll(this.resultFragmentIds);
        HashSet commonIds = new HashSet(originalModelIds);
        commonIds.retainAll(this.resultFragmentIds);
        this.resultFragment.addAll(this.originalModelIdTable.getFragmentFromIds(commonIds));
        Iterator it = this.addedElementIds.iterator();
        while (it.hasNext()) {
            id = (String)it.next();
            EObject updatedElem = this.updatedCopyIdTable.getModelElement(id);
            EClass c = updatedElem.eClass();
            ModelWrapper w = ModelWrapper.getRegistry(this.format);
            if (w == null) {
                throw new RuntimeException("no factory found " + this.format);
            }
            EObject newElem = w.create(c);
            this.originalModelIdTable.assignId(id, newElem);
            this.resultFragment.add(newElem);
        }
        it = this.resultFragmentIds.iterator();
        while (it.hasNext()) {
            id = (String)it.next();
            EObject originalElem = this.originalModelIdTable.getModelElement(id);
            EObject updatedElem = this.updatedCopyIdTable.getModelElement(id);
            this.copyElement(originalElem, updatedElem);
        }
    }

    public Collection getRemovedElementIds() {
        return this.removedElementIds;
    }

    public Collection getAddedElements() {
        return this.originalModelIdTable.getFragmentFromIds(this.addedElementIds);
    }

    public Collection getAddedElementIds() {
        return this.addedElementIds;
    }

    public Collection getResultFragment() {
        return this.resultFragment;
    }

    public Collection getResultFragmentIds() {
        return this.resultFragmentIds;
    }

    void copyElement(EObject originalElem, EObject updatedElem) {
        Iterator it = originalElem.eClass().getEAllAttributes().iterator();
        while (it.hasNext()) {
            EAttribute a = (EAttribute)it.next();
            if (!a.isChangeable() || a.isDerived()) continue;
            originalElem.eGet((EStructuralFeature)a);
            Object updatedValue = updatedElem.eGet((EStructuralFeature)a);
            originalElem.eSet((EStructuralFeature)a, updatedValue);
        }
        it = updatedElem.eClass().getEAllReferences().iterator();
        while (it.hasNext()) {
            EReference r = (EReference)it.next();
            if (!r.isChangeable() || r.isDerived()) continue;
            if (r.isMany()) {
                List oldLinkList = (List)originalElem.eGet((EStructuralFeature)r);
                List newLinkList = (List)updatedElem.eGet((EStructuralFeature)r);
                Vector oldInternalLinkList = new Vector(oldLinkList);
                oldInternalLinkList.retainAll(this.originalFragment);
                Vector newInternalLinkList = new Vector(newLinkList);
                newInternalLinkList.retainAll(this.updatedFragment);
                List oldInternalLinkIds = this.originalModelIdTable.getIdsFromFragment(oldInternalLinkList);
                List newInternalLinkIds = this.updatedCopyIdTable.getIdsFromFragment(newInternalLinkList);
                Vector idsToRemove = new Vector(oldInternalLinkIds);
                idsToRemove.removeAll(newInternalLinkIds);
                Iterator it2 = idsToRemove.iterator();
                while (it2.hasNext()) {
                    String id = (String)it2.next();
                    oldLinkList.remove(this.originalModelIdTable.getModelElement(id));
                }
                Vector idsToAdd = new Vector(newInternalLinkIds);
                idsToAdd.removeAll(oldInternalLinkIds);
                Iterator it22 = idsToAdd.iterator();
                while (it22.hasNext()) {
                    String id = (String)it22.next();
                    oldLinkList.add(this.originalModelIdTable.getModelElement(id));
                }
                continue;
            }
            EObject oldLink = (EObject)originalElem.eGet((EStructuralFeature)r);
            EObject newLink = (EObject)updatedElem.eGet((EStructuralFeature)r);
            if (newLink != null) {
                if (!this.updatedFragment.contains(newLink)) continue;
                String id = this.updatedCopyIdTable.getId(newLink);
                originalElem.eSet((EStructuralFeature)r, (Object)this.originalModelIdTable.getModelElement(id));
                continue;
            }
            if (oldLink == null || !this.originalFragment.contains(oldLink)) continue;
            originalElem.eUnset((EStructuralFeature)r);
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

