/*
 * $RCSfile: SessionManager.java,v $
 * $Date: 2006/01/26 14:48:59 $
 * $Revision: 1.1.2.2 $
 * $Author: andreys $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * SessionManager.java  
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.1.2.2 $ $Date: 2006/01/26 14:48:59 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class SessionManager {
    
    private static Logger logger= Logger.getLogger(SessionManager.class);

    /**
     * Sessions Map associates sessionId to a SessionProviderProxy
     * 
     */
    private Map sessions = new Hashtable();

    /**
     * 
     * getProviderProxy returns a SessionProviderProxy for a given sessionId
     * 
     * @param sessionId
     * @return SessionProviderProxy
     * 
     */
    public SessionProviderProxy getProviderProxy(String sessionId) {

        return (SessionProviderProxy) (sessions.get(sessionId));
    }

    public void putProviderProxy(String sessionId, SessionProviderProxy proxy) {
        sessions.put(sessionId, proxy);
    }

    public void removeSession(String sessionId) {
        sessions.remove(sessionId);
    }

    public String[] getAllOpenSessions() {
        String[] sessionsArray;
        sessionsArray = (String[]) sessions.keySet().toArray();
        return sessionsArray;
    }

    public String[] getOpenSessions(String serviceName) {
        Collection returnSessionIdsSet = new Vector();

        QualifiedServiceName qname = QualifiedServiceName
                .getQualifiedServiceName(serviceName);

        Iterator it = sessions.values().iterator();
        // check all Proxies
        for (int index = 0; it.hasNext(); index++) {
            SessionProviderProxy testProxy = (SessionProviderProxy) it.next();
            Tool tool = testProxy.getToolDescription();
            // check tool name
            if (qname.interfaceName != null) {
                // check only interfaceName
                if (qname.toolName != null) {
                    // check toolName matching
                    if (tool.getName().matches(qname.toolName)
                            || tool.getInterface().getName().matches(
                                    qname.interfaceName)) {
                        String sessionId = (String) ((Vector) sessions.keySet())
                                .get(index);
                        returnSessionIdsSet.add(sessionId);
                    }
                } else if (tool.getInterface().getName().matches(
                        qname.interfaceName)) {
                    String sessionId = (String) ((Vector) sessions.keySet())
                            .get(index);
                    returnSessionIdsSet.add(sessionId);
                }
            } else {
                // check only for serviceName of all services
                EList serviceList = tool.getInterface().getService();
                boolean isFound = false;
                for (int i = 0; (i < serviceList.size()) || isFound; i++) {
                    ModelingService ms = (ModelingService) serviceList.get(i);
                    if (ms.getName().matches(qname.serviceName)) {
                        isFound = true;
                        String sessionId = (String) ((Vector) sessions.keySet())
                                .get(index);
                        returnSessionIdsSet.add(sessionId);
                    }
                }
            }
        }

        return (String[]) returnSessionIdsSet.toArray();
    }
}
