/*
 * $RCSfile: EndPointManagerImpl.java,v $
 * $Date: 2006/01/26 14:48:59 $
 * $Revision: 1.1.2.2 $
 * $Author: andreys $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * EndPointManagerImpl.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1.2.2 $ $Date: 2006/01/26 14:48:59 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

import org.apache.log4j.Logger;

public class EndPointManagerImpl implements EndPointManager {
        
    private static Logger logger = Logger.getLogger(EndPointManagerImpl.class);
    
    private static EndPointManager endPointManager = new EndPointManagerImpl();
    
    public static EndPointManager getInstance() {
        return endPointManager;        
    }
    
    Map endPointMap = new Hashtable();
     
    
    public EndPoint getEndPoint(String relativePath) {
       for(Iterator it = endPointMap.keySet().iterator(); it.hasNext();) {
          String incompleteRelativePath = (String) it.next();
          if(relativePath.startsWith(incompleteRelativePath)) {
              return (EndPoint) endPointMap.get(incompleteRelativePath);
          }
       } 
       return null;
    }
    

    public void putEndPoint(String incompleteRelativePath, EndPoint endPoint) {
       endPointMap.put(incompleteRelativePath, endPoint);            
    }
    
    public void execute(String urlPath, SOAPEnvelope req, SOAPEnvelope resp) {
       EndPoint ep = getEndPoint(urlPath);
       if(ep!=null) {
           try {
            ep.execute(urlPath, req, resp);
        } catch (SOAPException e) {
            e.printStackTrace();
        }
       } else {
           logger.debug("not EndPoint for url path : " +urlPath);
           
       }
    }    
}
