/*
 * $RCSfile: ToolStubImpl.java,v $
 * $Date: 2006/01/26 14:48:59 $
 * $Revision: 1.2.2.1 $
 * $Author: andreys $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * ToolStubImpl.java Add description 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * @version $Revision: 1.2.2.1 $ $Date: 2006/01/26 14:48:59 $
 */
package org.eclipse.mddi.modelbus.adapter.user.impl;

import org.eclipse.mddi.modelbus.adapter.user.ToolStub;
import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationConsumer;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericSessionProvider;

public class ToolStubImpl implements ToolStub {
    /**
     * Object for receiving the sessionless invocation from the Adapter.
     * This object offers the functionality of the Tool.
     */
    GenericProvider provider;
    
    /**
     * Object for receiving the sessionful invocation from the Adapter.
     * This object offers the functionality of the Tool.
     */
    GenericSessionProvider sessionProvider;

    
    public ToolStubImpl() {
        
    }
    
    
    
    /**
     * Sets an object that executes sessionless Modeling Services.
     * @param si object that executes sessionless Modeling Services.
     */
    public void setServiceInvocation(GenericProvider si) {
        provider = si;
    }
    /**
     * Obtains an object that executes sessionless Modeling Services.
     * @return object that executes sessionless Modeling Services.
     */
    public GenericProvider getServiceInvocation() {
        return provider;
    }
    
    /**
     * Sets an object that executes sessionful Modeling Services.
     * @param si object that executes sessionful Modeling Services.
     */
    public void setSessionServiceInvocation(GenericSessionProvider si) {
        sessionProvider = si;
    }   
    /**
     * Obtains an object that executes sessionful Modeling Services.
     * @return object that executes sessionful Modeling Services.
     */
    public GenericSessionProvider getSessionServiceInvocation() {
        return sessionProvider;
    }
    
//////////////////////////////////// notification-related part  

    /**
     * Object for receiving the notification from Adapter.
     * This object offers the functionality of the Tool.
     */
    NotificationConsumer notifConsumer;
    
    /**
     * Sets object for receiving the notification from the Adapter.
     * @param nc An object implementing the NotificationConsumer interface.
     *           On notification, this object will perform the action according to the Tool-specific logic.
     * 
     */
    public void setNotificationConsumer(NotificationConsumer nc) {
        notifConsumer = nc;
    }
    /**
     * Gets object that is reponsible for processing notifications.
     * @return An object implementing the NotificationConsumer interface.
     */
    public NotificationConsumer getNotificationConsumer() {
        return notifConsumer;   
    }
    /**
     * @return Returns the provider.
     */
    public GenericProvider getProvider() {
        return provider;
    }
    /**
     * @param provider The provider to set.
     */
    public void setProvider(GenericProvider provider) {
        this.provider = provider;
    }
    /**
     * @return Returns the sessionProvider.
     */
    public GenericSessionProvider getSessionProvider() {
        return sessionProvider;
    }
    /**
     * @param sessionProvider The sessionProvider to set.
     */
    public void setSessionProvider(GenericSessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }
}
