/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelWrapper;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.wrapper.emf.EmfModelWrapper;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.MBXmiResourceFactory;
import org.eclipse.mddi.modelbus.description.impl.DescriptionPackageImpl;

public class ModelBusResourceSet
extends ResourceSetImpl {
    static GlobalResourceRegistry globalResourceRegistry = new GlobalResourceRegistry();
    public static final URI MB_DEFAULT_RES_URI = URI.createURI((String)"default_resource.modelbus");
    private static Logger logger = Logger.getLogger((String)"ModelBusResourceSet");

    static {
        Map m = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        m.put("*", new XMIResourceFactoryImpl());
        MBXmiResourceFactory.init();
        ModelWrapper.addRegistry("EMF", new EmfModelWrapper());
        try {
            EcorePackage p = EcorePackageImpl.init();
            Resource r = p.eResource();
            logger.debug((Object)("Ecore model in Resource " + r));
            logger.debug((Object)("Ecore model in Resource " + r.getResourceSet()));
            ModelBusResourceSet.getGlobalResourceRegistry().registerResource(r.getURI(), r);
        }
        catch (Exception e) {
            logger.error((Object)"cannot bind Ecore model to GlobalRegistry", (Throwable)e);
        }
        DescriptionPackageImpl.init();
        LoggerConfigurator.configure();
    }

    public static void init() {
    }

    public static GlobalResourceRegistry getGlobalResourceRegistry() {
        return globalResourceRegistry;
    }

    public static void registerEPackages(Resource r) {
        Iterator it = r.getContents().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof EPackage)) continue;
            ModelBusResourceSet.registerEPackage((EPackage)o);
        }
    }

    public static void registerEPackage(EPackage p) {
        EPackage registered;
        String uri = p.getNsURI();
        if (uri == null || "".equals(uri)) {
            EPackage superp = p.getESuperPackage();
            uri = superp == null ? "http://model/" + p.getName() : String.valueOf(superp.getNsURI()) + "/" + p.getName();
            p.setNsURI(uri);
        }
        if ((registered = EPackage.Registry.INSTANCE.getEPackage(p.getNsURI())) != null && registered != p) {
            logger.warn((Object)("The EPackage for NS URI " + p.getNsURI() + " changed: " + registered + " -> " + p));
        }
        EPackage.Registry.INSTANCE.put((Object)p.getNsURI(), (Object)p);
        Iterator it = p.getESubpackages().iterator();
        while (it.hasNext()) {
            EPackage subp = (EPackage)it.next();
            ModelBusResourceSet.registerEPackage(subp);
        }
    }

    public static boolean isRegistered(EPackage p) {
        return EPackage.Registry.INSTANCE.containsValue((Object)p);
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        EPackage ePackage = this.getPackageRegistry().getEPackage(uri.toString());
        if (ePackage != null) {
            return ePackage.eResource();
        }
        Resource r = globalResourceRegistry.getResource(uri);
        return r;
    }

    public Resource createResource(URI uri) {
        Resource result = globalResourceRegistry.getResource(uri);
        if (result != null) {
            return result;
        }
        result = super.createResource(uri);
        if (result == null) {
            return null;
        }
        if (ModelBusResourceSet.hasGlobalURIScheme(uri)) {
            try {
                globalResourceRegistry.registerResource(uri, result);
            }
            catch (GlobalResourceException e) {
                logger.error((Object)"createResource", (Throwable)e);
            }
        }
        return result;
    }

    public static boolean hasGlobalURIScheme(URI uri) {
        if ("pathmap".equals(uri.scheme())) {
            return true;
        }
        return "http".equals(uri.scheme());
    }

    public static class GlobalResourceRegistry {
        public static final String GLOBAL_URI_SCHEME = "pathmap";
        private URIConverter uriConverter = new URIConverterImpl();
        private Map resourceMap = new Hashtable();

        public Collection getResources() {
            return this.resourceMap.values();
        }

        public void registerResource(URI globalURI, Resource r) throws GlobalResourceException {
            if (!ModelBusResourceSet.hasGlobalURIScheme(globalURI)) {
                throw new GlobalResourceException("Global URI must have scheme 'pathmap' or 'http'");
            }
            if (ModelBusResourceSet.hasGlobalURIScheme(r.getURI()) && !globalURI.equals((Object)r.getURI())) {
                throw new GlobalResourceException("Resource already associated to " + r.getURI());
            }
            if (this.resourceMap.containsKey(globalURI)) {
                Resource boundResource = (Resource)this.resourceMap.get(globalURI);
                if (boundResource == r) {
                    logger.debug((Object)("Duplicated registration (ignored): " + globalURI.toString()));
                    return;
                }
                throw new GlobalResourceException("Conflict registration: " + globalURI + " is already bound to " + boundResource + ". Cannot rebind to " + r);
            }
            if (this.resourceMap.containsValue(r)) {
                throw new GlobalResourceException("Conflict registration: " + r + " is already registered with a different URI." + " Cannot rebind to " + globalURI);
            }
            this.resourceMap.put(globalURI, r);
            logger.debug((Object)("register uri: " + globalURI));
            if (!globalURI.equals((Object)r.getURI())) {
                this.uriConverter.getURIMap().put(r.getURI(), globalURI);
                r.setURI(globalURI);
            }
        }

        public Resource getResource(URI uri) {
            Resource r = null;
            if (ModelBusResourceSet.hasGlobalURIScheme(uri) && (r = (Resource)this.resourceMap.get(uri)) != null) {
                return r;
            }
            URI normalizedURI = this.uriConverter.normalize(uri);
            r = (Resource)this.resourceMap.get(normalizedURI);
            if (r == null && ModelBusResourceSet.hasGlobalURIScheme(normalizedURI)) {
                logger.debug((Object)("resolve uri: " + uri + " -> " + r));
            }
            return r;
        }

        public URIConverter getURIConverter() {
            return this.uriConverter;
        }
    }

    public static class GlobalResourceException
    extends Exception {
        private static final long serialVersionUID = -4580625527117814989L;

        public GlobalResourceException(String message) {
            super(message);
        }
    }
}

