/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelWrapper;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.ModelManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.AbstractMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.description.abstract_.DirectionKind;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.xml.sax.SAXException;

public class CopyRestoreFragmentMarshaler
extends AbstractMarshaler {
    public static final String INOUT_SCOPE = "MODELBUS_INOUT_SCOPE";
    public static final String OUT_SCOPE = "MODELBUS_OUT_SCOPE";
    public static final String IN_SCOPE = "MODELBUS_IN_SCOPE";
    boolean recursivelyIncludeSubelements = false;
    boolean doRestore = false;
    boolean useScope = false;
    Collection inScope = null;
    Collection outScope = null;
    Collection inoutScope = null;
    private ModelManager modelManager = new ModelManager();

    public CopyRestoreFragmentMarshaler(Properties p) {
        this.recursivelyIncludeSubelements = p.getProperty("marshal.recursivelyIncludeSubelements", "false").equals("true");
        this.doRestore = p.getProperty("marshal.doRestore", "false").equals("true");
        this.useScope = p.getProperty("marshal.useScope", "false").equals("true");
    }

    public void marshallScope(String scopeDirection, Collection model, SOAPElement topElem) throws SOAPException {
        Collection wrappedModel = CopyRestoreFragmentMarshaler.wrap(model, this.recursivelyIncludeSubelements);
        if (scopeDirection.equals(INOUT_SCOPE)) {
            this.inoutScope = wrappedModel;
        } else if (scopeDirection.equals(IN_SCOPE)) {
            this.inScope = wrappedModel;
        } else if (scopeDirection.equals(OUT_SCOPE)) {
            this.outScope = wrappedModel;
        }
        this.modelManager.getManagedModel().addAll(wrappedModel);
        String content = this.modelManager.exportFragmentToXMI(wrappedModel);
        SOAPElement paramSoapElem = topElem.addChildElement(scopeDirection);
        paramSoapElem.addTextNode(content);
    }

    public void unmarshallScope(SOAPElement topElem) throws IOException, SOAPException {
        SOAPElement inoutScopeElem;
        SOAPElement outScopeElem;
        SOAPElement inScopeElem = SoapUtil.getChildByLocalName(topElem, IN_SCOPE);
        if (inScopeElem != null) {
            this.unmarshallScope(IN_SCOPE, inScopeElem);
        }
        if ((outScopeElem = SoapUtil.getChildByLocalName(topElem, OUT_SCOPE)) != null) {
            this.unmarshallScope(OUT_SCOPE, outScopeElem);
        }
        if ((inoutScopeElem = SoapUtil.getChildByLocalName(topElem, INOUT_SCOPE)) != null) {
            this.unmarshallScope(INOUT_SCOPE, inoutScopeElem);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unmarshallScope(String scopeDirection, SOAPElement elem) throws IOException, SOAPException {
        String content = elem.getValue();
        if (scopeDirection.equals(IN_SCOPE) || scopeDirection.equals(OUT_SCOPE) || scopeDirection.equals(INOUT_SCOPE) && !this.doRestore) {
            try {
                Collection resultModel = this.modelManager.loadXMI(content);
                if (scopeDirection.equals(INOUT_SCOPE)) {
                    this.inoutScope = resultModel;
                    return;
                }
                if (scopeDirection.equals(IN_SCOPE)) {
                    this.inScope = resultModel;
                    return;
                }
                if (!scopeDirection.equals(OUT_SCOPE)) return;
                this.outScope = resultModel;
                return;
            }
            catch (SAXException e) {
                throw new SOAPException((Throwable)e);
            }
            catch (XMIException e) {
                throw new SOAPException((Throwable)e);
            }
        }
        try {
            this.modelManager.mergeWithXMI(this.inoutScope, content);
            return;
        }
        catch (SAXException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (XMIException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public void marshalModel(Parameter p, Object value, SOAPElement elem) throws SOAPException, IOException {
        String content = null;
        Collection model = (Collection)value;
        if (this.useScope) {
            Collection wrappedModel = CopyRestoreFragmentMarshaler.wrap(model, false);
            elem.setAttribute("xsi:type", "modelbus:ModelRef");
            Iterator it = wrappedModel.iterator();
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                String id = this.modelManager.getIdTable().getId(o);
                if (id == null && o == null) {
                    throw new RuntimeException("Parameter must be in scope. " + o);
                }
                content = content == null ? id : String.valueOf(content) + " " + id;
            }
        } else {
            Collection wrappedModel = CopyRestoreFragmentMarshaler.wrap(model, this.recursivelyIncludeSubelements);
            elem.setAttribute("xsi:type", "modelbus:Model");
            this.modelManager.getManagedModel().addAll(wrappedModel);
            content = this.modelManager.exportFragmentToXMI(wrappedModel);
        }
        elem.addTextNode(content);
    }

    public Object unmarshalModel(Parameter p, SOAPElement elem) throws SOAPException, IOException {
        String content = elem.getValue();
        DirectionKind dir = p.getDirection();
        if (this.useScope) {
            Vector<EObject> resultModel = new Vector<EObject>();
            StringTokenizer st = new StringTokenizer(content);
            while (st.hasMoreTokens()) {
                String id = st.nextToken();
                EObject o = this.modelManager.getIdTable().getModelElement(id);
                if (o == null) {
                    throw new RuntimeException("No element found id=" + id);
                }
                resultModel.add(o);
            }
            return CopyRestoreFragmentMarshaler.unwrap(resultModel, false);
        }
        if (dir.equals(DirectionKind.IN_LITERAL) || dir.equals(DirectionKind.OUT_LITERAL) || dir.equals(DirectionKind.INOUT_LITERAL) && !this.doRestore) {
            try {
                Collection resultModel = this.modelManager.loadXMI(content);
                return CopyRestoreFragmentMarshaler.unwrap(resultModel, this.recursivelyIncludeSubelements);
            }
            catch (XMIException e) {
                throw new SOAPException((Throwable)e);
            }
            catch (SAXException e) {
                throw new SOAPException((Throwable)e);
            }
        }
        throw new RuntimeException("does not support now");
    }

    public boolean isUseScope() {
        return this.useScope;
    }

    public Collection getInoutScope() {
        return CopyRestoreFragmentMarshaler.unwrap(this.inoutScope, this.recursivelyIncludeSubelements);
    }

    public Collection getInScope() {
        return CopyRestoreFragmentMarshaler.unwrap(this.inScope, this.recursivelyIncludeSubelements);
    }

    public Collection getOutScope() {
        return CopyRestoreFragmentMarshaler.unwrap(this.outScope, this.recursivelyIncludeSubelements);
    }

    static Collection wrap(Collection src, boolean includesChildren) {
        if (src == null) {
            return null;
        }
        Collection result = ModelWrapper.wrap(src);
        if (includesChildren) {
            result = ModelUtil.flattenHirachicalCollection(result);
        }
        return result;
    }

    static Collection unwrap(Collection src, boolean onlyTopElems) {
        if (src == null) {
            return null;
        }
        Collection result = onlyTopElems ? ModelUtil.getTopElemsInFragment(src) : src;
        return ModelWrapper.unwrap(result);
    }
}

