/*
 * $RCSfile: DefaultToolSelector.java,v $
 * $Date: 2006/01/26 14:48:59 $
 * $Revision: 1.2.2.3 $
 * $Author: andreys $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * DefaultToolSelector.java 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * @version $Revision: 1.2.2.3 $ $Date: 2006/01/26 14:48:59 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.registry;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.QualifiedServiceName;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ProviderEndPoint;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class DefaultToolSelector implements ToolSelectionStrategy {

    public Tool selectTool(String serviceName, Collection tools) {
        QualifiedServiceName qname = QualifiedServiceName
                .getQualifiedServiceName(serviceName);

        // find local tool first!!
        Tool t = findLocalTool(serviceName);
        if (t!=null) return t;
        

        // for other cases, search in the registry output

        if (tools == null)
            return null;

        Iterator it = tools.iterator();
        ModelingService ms = null;
        while (it.hasNext() && (ms == null)) {
            t = (Tool) it.next();
            if ((qname.toolName != null)
                    && (!qname.toolName.equals(t.getName())))
                continue;
            if ((qname.interfaceName != null)
                    && (!qname.interfaceName.equals(t.getInterface().getName())))
                continue;
            ms = DescriptionUtil.getServiceDescription(qname.serviceName, t);
        }
        if (ms != null) {
            return t;
        }
        return null;
    }

    public static Tool findLocalTool(String serviceName) {
        QualifiedServiceName qname = QualifiedServiceName
                .getQualifiedServiceName(serviceName);

        // find local tool first!!
        if (qname.toolName != null) {
            AdapterStub adapter=null;
            String relativePath = ProviderEndPoint
                    .getRelativePath(qname.toolName);
            ProviderEndPoint ep = (ProviderEndPoint) EndPointManagerImpl
                    .getInstance().getEndPoint(relativePath);
            if(ep!=null) adapter = ep.getAdapterOfProviderTool(relativePath);
            if (adapter != null) {
                Tool testTool = adapter.getToolDescription();
                ModelingService ms = DescriptionUtil.getServiceDescription(
                        serviceName, testTool);
                if (ms != null)
                    return testTool;
            }
        }
        
        return null;

    }

    // TODO public Tool selectTool(request, serviceName, tools)}
}