/*
 * $RCSfile: DefaultSerializer.java,v $
 * $Date: 2006/01/26 14:48:59 $
 * $Revision: 1.1.2.5 $
 * $Author: andreys $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * DefaultSerializer.java implements for prameter serialisation methods
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.1.2.5 $ $Date: 2006/01/26 14:48:59 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi;

import java.io.IOException;
import java.util.Collection;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.Serializer;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.Type;

/*
 * DefaultSerializer
 * 
 */

public class DefaultSerializer implements Serializer {

    private static Logger logger = Logger.getLogger(DefaultSerializer.class);

    /**
     * 
     */
    public DefaultSerializer() {
        super();
        // TODO Auto-generated constructor stub
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Serializer#serialize(org.eclipse.mddi.modelbus.description.abstract_.Parameter,
     *      java.lang.Object)
     */
    public String serialize(Parameter param, Object value) throws Exception {
        Type t = param.getType();
        if (t instanceof ModelType) {
            if (!(value instanceof Collection)) {
                logger.error("Serialize error, model must be collection - "
                        + param.getName());
                throw new Exception(
                        "Serialize error, model must be collection - "
                                + param.getName());
            }
            return serializeModel(value);
        } else {
            logger.debug("Non ModelType value:" + t.getName() + " : " + value);
            return value.toString();
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Serializer#deserialize(org.eclipse.mddi.modelbus.description.abstract_.Parameter,
     *      java.lang.Object)
     */
    public Object deserialize(Parameter param, String value) throws Exception {
        Type t = param.getType();
        String typeName = t.getName();
        if (t instanceof ModelType) {
            return deserializeModel(value);

        } else {
            if (typeName.equalsIgnoreCase("string")) {
                return value;
            } else if (typeName.equalsIgnoreCase("integer")) {
                return new Integer(Integer.parseInt(value));
            } else if (typeName.equalsIgnoreCase("double")) {
                return new Double(Double.parseDouble(value));
            } else if (typeName.equalsIgnoreCase("boolean")) {
                return Boolean.valueOf(value);
            } else {
                throw new Exception("Deserialize error, unknown PrimitiveType "
                        + typeName);
            }
        }
    }

    private String serializeModel(Object value) throws IOException {

        Collection model = (Collection) value;

        return Emf2XmiConversion.convertToString(model);

    }

    private Object deserializeModel(String value) throws IOException {

        return Xmi2EmfConversion.convertFromString(value, true);

    }

}
