/*
 * $RCSfile: TransportManager.java,v $
 * $Date: 2006/01/26 14:48:59 $
 * $Revision: 1.2.2.4 $
 * $Author: andreys $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * TransportManager.java 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * @version $Revision: 1.2.2.4 $ $Date: 2006/01/26 14:48:59 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.AdapterContainerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.Serializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.AbstractInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.local.LocalInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.local.LocalSessionInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.CopyRestoreFragmentWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultSessionWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.CopyRestoreFragmentWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.DefaultSessionWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.DefaultWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.WsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

/**
 * 
 * The responsibility of this class is to chooses the mechanisms corresponding
 * to the options specified in the Adapter stub. It contains some definition of
 * properties that can be use to customized the invocation style
 * 
 * @author P. Sriplakich, Andrey Sadovykh (LIP6)
 * 
 * 
 */
public class TransportManager {

    private static Logger logger = Logger.getLogger(TransportManager.class);

    SessionManager sessionManager = new SessionManager();

    Map toolDesc_proxy = new Hashtable();

    AdapterStub adapter;

    Serializer serializer;

    public TransportManager(AdapterStub adapter) {
        this.adapter = adapter;
    }

    /**
     * 
     * This method is call to invoke a service locally or remotely.
     * 
     * @return
     * 
     * 
     */
    public ProviderProxy getProviderProxy(Tool t) {
        ProviderProxy p = null;

        p = getWsInvocationSender(t);
        p.setToolDescription(t);

        if (serializer != null)
            p.getMarshaler().setSerializer(serializer);
        logger.debug("Marshaler:"+p.getMarshaler());

        return p;
    }

    public SessionProviderProxy getSessionProviderProxy(Tool t) {
        SessionProviderProxy p = null;
        if (!DescriptionUtil.getIsSessionEnabled(t))
            return p;
        // if local AdapterContainer contains Tool t
        if (AdapterContainerImpl.getInstance().containTool(t)) {
            p = new LocalSessionInvocationSender(adapter.getProperties());
        } else
            p = new DefaultSessionWsInvocationSender(adapter.getProperties());

        p.setSessionManager(this.sessionManager);
        p.setToolDescription(t);


        if (serializer != null)
            p.getMarshaler().setSerializer(serializer);
        return p;
    }

    public void removeProviderProxy(ProviderProxy p) {
        toolDesc_proxy.values().remove(p);

    }

    public Collection getAllProviderProxies() {
        return toolDesc_proxy.values();
    }

    private ProviderProxy getWsInvocationSender(Tool t) {
        String style = adapter.getProperties().getProperty(
                AdapterStub.PROP_invocationStyle,
                AdapterStub.PROP_invocationStyle_Default);
        ProviderProxy s = null;
        if (style.equals(AdapterStub.PROP_invocationStyle_Default)) {
            // if local AdapterContainer contains Tool t
            if (AdapterContainerImpl.getInstance().containTool(t)) {

                logger.debug("Local Call");

                s = new LocalInvocationSender(adapter.getProperties());
            } else
                s = new DefaultWsInvocationSender(adapter.getProperties());
            return s;
        } else {
            s = new CopyRestoreFragmentWsInvocationSender(adapter
                    .getProperties());
            return s;
        }
    }

    public WsInvocationReceiver getWsInvocationReceiver() {
        String style = adapter.getProperties().getProperty(
                AdapterStub.PROP_invocationStyle,
                AdapterStub.PROP_invocationStyle_Default);

        WsInvocationReceiver r;

        if (DescriptionUtil.getIsSessionEnabled(adapter.getToolDescription())) {
            // Session case
            r = new DefaultSessionWsInvocationReceiver(adapter);

        } else {
            // Default case
            if (style.equals(AdapterStub.PROP_invocationStyle_Default)) {
                r = new DefaultWsInvocationReceiver(adapter);

            } else {
                r = new CopyRestoreFragmentWsInvocationReceiver(adapter);
                return r;
            }
        }

        // Setting serializer
        if (serializer != null)
            r.getMarshaler().setSerializer(serializer);

        return r;

    }

    /**
     * @return Returns the sessionManager.
     */
    public SessionManager getSessionManager() {
        return sessionManager;
    }

    /**
     * @return Returns the serializer.
     */
    public Serializer getSerializer() {
        return serializer;
    }

    /**
     * @param serializer
     *            The serializer to set.
     */
    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

}
