/*
 * $RCSfile: Marshaler.java,v $
 * $Date: 2006/01/26 14:48:59 $
 * $Revision: 1.1.2.2 $
 * $Author: andreys $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * ParameterMarshaler.java Add description 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * @version $Revision: 1.1.2.2 $ $Date: 2006/01/26 14:48:59 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws;

import javax.xml.soap.SOAPElement;

import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.Serializer;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public interface Marshaler {

    /**
     * Marshalls a parameter value 
     * and placed the result in the SOAP Element <code>topElem</code>.
     * 
     * <p>The value of each parameter is placed in a seperate XML tag.
     * For example, let <code>topElem</code> be the SOAP element &lt;my_service&gt;...&lt;/my_service&gt;.
     * Let the parameter name be "param1".
     * The parameter value will be placed in the SOAP element &lt;param1&gt;...&lt;/param1&gt; inside the element my_service.
     * 
     * <br><br> For model type, it must delegate to marshalModel(...)
     * 
     * @param p the description of the parameter, as defined in ModelBus metamodel.
     * @param parameterValue the value of the parameter to be marshalled
     * @param topElem the SOAPElement where the value of the parameter will be placed.
     * @throws SOAPException
     * @throws IOException
     * @throws Exception 
     * 
     */
    public void marshal(Parameter p, Object parameterValue,
            SOAPElement topElem) throws Exception;

    /**
     * Extracts the parameter value from the SOAP element <code>topElem</code>. 
     * 
     * <br><br> For model type, it must delegate to unmarshalModel(...)
     * 
     * @param p the description of the parameter, as defined in ModelBus metamodel.
     * @param topElem the SOAPElement from which the value of the parameter will be extracted.
     * @return the extracted value
     * @throws SOAPException
     * @throws IOException
     * @throws Exception 
     */
    public Object unmarshal(Parameter p, SOAPElement topElem)
            throws Exception;


    public void marshal(Parameter[] params, Object[] parameterValues,
            SOAPElement topElem) throws Exception;

    public Object[] unmarshal(Parameter[] params, SOAPElement topElem) throws Exception;
    
    public void marshalModel(Parameter p, Object value,
            SOAPElement elem) throws Exception;

    public Object unmarshalModel(Parameter p, SOAPElement elem)
            throws Exception;    
    
    public Serializer getSerializer();
    
    public void setSerializer(Serializer serializer);

}